<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2.5rem !important;
    }
    ul#myTab {
        background: #333 !important;
        height: 50px !important;
    }
    a.nav-link {
        background: #333333 !important;

    }
    .nav-tabs .nav-link{
        color: #fff !important;
    }
    a.nav-link.active {
        background: #f3f4f6 !important;
        border-radius: 0 !important;
        color: #000 !important;
    }
</style>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>

<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="container mx-auto px-4 py-6">
         <?php $__env->slot('header', null, []); ?> 
            <?php echo $__env->make('prisons.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
         <?php $__env->endSlot(); ?>


        <a href="<?php echo e(route('prisons.index')); ?>" class="btn btn-danger mb-3">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">Détail crime</h4>
        <hr>


        <div class="container">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="p-3">
                <!-- resources/views/admin/users/create.blade.php -->
                 <div class="card shadow p-4">
                    <div class="row">
                        <div class="col-lg-6">
                            <h4><b><?php echo e($prison->code); ?></b>-<?php echo e($prison->name); ?> | <span class="text-danger text-uppercase"><?php echo e($prison->type); ?></span></h4><hr>
                            <p class="mb-0"><?php echo e($prison->description); ?></p>
                        </div>
                        <div class="col-lg-6 text-right" style="text-align: right">
                            <h4><b>Localisation:</b> <?php echo e($prison->quartier->name); ?></h4><hr>
                            <p class="mb-0"><?php echo e($prison->user->name); ?></p>
                        </div>
                    </div>
                </div>
                <div class="content mt-2">
                    <!-- Onglets -->
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <a class="nav-link active" id="home-tab" data-bs-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Tableau de bord</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="profile-tab" data-bs-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Arrestations</a>
                        </li>
                        
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="contact-tab" data-bs-toggle="tab" href="#contact" role="tab" aria-controls="contact" aria-selected="false">Interventions</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="logistique-tab" data-bs-toggle="tab" href="#logistique" role="tab" aria-controls="contact" aria-selected="false">Logistique</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="user-tab" data-bs-toggle="tab" href="#user" role="tab" aria-controls="contact" aria-selected="false">Utilisateur</a>
                        </li>
                        
                    </ul>
                    
                    <!-- Contenu des onglets -->
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                            <div class="card shadow p-2">
                                <p class="text-center">Bienvenue dans la section tableau de bord de la prison <b><?php echo e($prison->name); ?></b> !</p>
                                <p class="text-center">Ici vous pouvez voir les statistiques de votre prison.</p>
                                <p class="text-center">Vous pouvez aussi voir les crimes et les arrestations de votre prison.</p>
                                <p class="text-center">Vous pouvez aussi voir les interventions de votre prison.</p>
                            </div>
                            <div class="card shadow p-2 mt-2">
                                <div class="row mb-4">
                                    <div class="col-md-3">
                                        <div class="card text-white bg-primary shadow">
                                            <div class="card-body">
                                                <h5 class="card-title">Arrestations</h5>
                                                <p class="card-text fs-3"><?php echo e($arrestationCount); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card text-white bg-success shadow">
                                            <div class="card-body">
                                                <h5 class="card-title">Matériels</h5>
                                                <p class="card-text fs-3"><?php echo e($materielCount); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card text-white bg-warning shadow">
                                            <div class="card-body">
                                                <h5 class="card-title">Interventions</h5>
                                                <p class="card-text fs-3"><?php echo e($interventionCount); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card text-white bg-info shadow">
                                            <div class="card-body">
                                                <h5 class="card-title">Agents affectés</h5>
                                                <p class="card-text fs-3"><?php echo e($userCount); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                
                                <h5 class="mt-4">Arrestations récentes</h5>
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Nom</th>
                                            <th>Date</th>
                                            <th>Motif</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $recentArrestations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $arrestation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($arrestation->nom ?? '-'); ?></td>
                                                <td><?php echo e($arrestation->created_at->format('d/m/Y')); ?></td>
                                                <td><?php echo e($arrestation->motif ?? '-'); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>

                                
                                <h5 class="mt-4">Matériels enregistrés</h5>
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Nom</th>
                                            <th>Quantité</th>
                                            <th>Ajouté le</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $recentMateriels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $materiel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($materiel->type ?? '-'); ?><?php echo e($materiel->description ?? '-'); ?></td>
                                                <td><?php echo e($materiel->quantite ?? '1'); ?></td>
                                                <td><?php echo e($materiel->created_at->format('d/m/Y')); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>

                                
                                <h5 class="mt-4">Interventions récentes</h5>
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Type</th>
                                            <th>Effectué par</th>
                                            <th>Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $recentInterventions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $intervention): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($intervention->type ?? '-'); ?></td>
                                                <td><?php echo e($intervention->user->name ?? 'N/A'); ?></td>
                                                <td><?php echo e($intervention->created_at->format('d/m/Y')); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="card shadow p-2 mt-2">
                                

                                <div class="row mt-5">
                                    <div class="col-md-6">
                                        <h5>📉 Arrestations mensuelles</h5>
                                        <canvas id="chartArrestations"></canvas>
                                    </div>
                                    <div class="col-md-6">
                                        <h5>📦 Répartition du matériel</h5>
                                        <canvas id="chartMateriel"></canvas>
                                    </div>
                                </div>

                                <div class="row mt-4">
                                    <div class="col-12">
                                        <h5>🗺️ Localisation de la prison</h5>
                                        <div id="map" style="height: 400px;"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                            <div class="card shadow p-2">
                                <table class="table table-bordered table-striped table-hover" id="myTable">
                                    <thead>
                                        <tr>
                                            <th>Matricule</th>
                                            <th>Prisonier</th>
                                            <th>Date d'Arrestation</th>
                                            <th>Prison</th>
                                            <th>Autorité Responsable</th>
                                            <th>Statut</th>
                                            <th>Crimes Associés</th>
                                            <?php if(Auth::user()->role === 'admin'): ?>
                                                <th>Action</th>
                                            <?php endif; ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $prison->arrestations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $arrestation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($arrestation->prisonier->matricule); ?></td>
                                                <td><?php echo e($arrestation->prisonier->nom); ?><?php echo e($arrestation->prisonier->prenom); ?></td>
                                                <td><?php echo e($arrestation->date_arrestation); ?></td>
                                                <td><?php echo e($arrestation->prison->name); ?></td>
                                                <td><?php echo e($arrestation->user->name); ?></td>
                                                <td><?php echo e($arrestation->statut); ?></td>
                                                <td>
                                                    <ul class="mb-0">
                                                        <?php $__currentLoopData = $arrestation->crimes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crime): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li><?php echo e($crime->code); ?> - <?php echo e($crime->libelle); ?></li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </td>

                                                <?php if(Auth::user()->role === 'admin'): ?>
                                                    <td>
                                                        <a href="<?php echo e(route('prisonier.arrestation.edit', $arrestation->id)); ?>">✏️</a>
                                                        <button onclick="confirmDelete(<?php echo e($crime->id); ?>)">🗑️</button>
                                                        <a href="<?php echo e(route('crimes.detail', $crime->id)); ?>" >👁️</a>
                                                    </td>
                                                <?php endif; ?>
                                                
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                            <table class="table table-bordered table-striped" id="myTable1">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Type d'operation</th>
                                        <th>Description</th>
                                        <th>Responsable</th>
                                        <th>Date d'operation</th>
                                        <th>Prison ID</th>
                                        <?php if(Auth::user()->role === 'admin'): ?>
                                            <th>Action</th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $prison->operations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $operation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($operation->id); ?></td>
                                            <td><?php echo e($operation->type); ?></td>
                                            <td><?php echo e($operation->description); ?></td>
                                            <td><?php echo e($operation->responsable); ?></td>
                                            <td><?php echo e($operation->date_operation); ?></td>
                                            <td><?php echo e($operation->prison ? $operation->prison->name : 'Non attribuée'); ?></td>
                                            <?php if(Auth::user()->role === 'admin'): ?>
                                            <td>
                                                    <a href="<?php echo e(route('operations.edit', $operation->id)); ?>">✏️</a>
                                            </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="tab-pane fade" id="logistique" role="tabpanel" aria-labelledby="contact-tab">
                            <table class="table table-bordered table-striped" id="myTable2">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Type de Matériel</th>
                                        <th>Description</th>
                                        <th>Quantité</th>
                                        <th>Date d'Attribution</th>
                                        <th>Prison Associée</th>
                                        <?php if(Auth::user()->role === 'admin'): ?>
                                            <th>Action</th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $prison->materielPrisons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $materiel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($materiel->id); ?></td>
                                            <td><?php echo e($materiel->type); ?></td>
                                            <td><?php echo e($materiel->description); ?></td>
                                            <td><?php echo e($materiel->quantite); ?></td>
                                            <td><?php echo e($materiel->date_attribution); ?></td>
                                            <td><?php echo e($materiel->prison ? $materiel->prison->name : 'Non attribuée'); ?></td>
                                            <?php if(Auth::user()->role === 'admin'): ?>
                                            <td>
                                                    <a href="<?php echo e(route('materiels.edit', $materiel->id)); ?>">✏️</a>
                                            </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="tab-pane fade" id="user" role="tabpanel" aria-labelledby="contact-tab">
                            <div class="card shadow p-4">
                                <table class="table table-hover table-bordered" id="myTable3">
                                    <thead>
                                        <tr>
                                            <th>Nom</th>
                                            <th>Email</th>
                                            <th>Téléphone</th>
                                            <th>Rôle</th>
                                            <th>Prison</th>
                                            <th>Quartier</th>
                                            <th>Arrondissement</th>
                                            <th>Zone</th>
                                            <th>Ville</th>
                                            <?php if(Auth::user()->role === 'admin'): ?>
                                                <th>Action</th>
                                            <?php endif; ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $prison->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($user->name); ?></td>
                                                <td><?php echo e($user->email); ?></td>
                                                <td><?php echo e($user->phone_number); ?></td>
                                                <td><?php echo e($user->role); ?></td>
                                                <td><?php echo e($user->prison->name ?? 'Aucune'); ?></td>
                                                <td><?php echo e($user->prison->quartier->name ?? '—'); ?></td>
                                                <td><?php echo e($user->prison->quartier->arrondissement->name ?? '—'); ?></td>
                                                <td><?php echo e($user->prison->quartier->arrondissement->zone->name ?? '—'); ?></td>
                                                <td><?php echo e($user->prison->quartier->arrondissement->zone->ville->name ?? '—'); ?></td>
                                                <?php if(Auth::user()->role === 'admin'): ?>
                                                    <td>
                                                        <a href="<?php echo e(route('users.edit', $user->id)); ?>">✏️</a>

                                                        <?php if(Auth::id() !== $user->id): ?>
                                                            <button onclick="confirmDelete(<?php echo e($user->id); ?>)">🗑️</button>

                                                            <form id="delete-form-<?php echo e($user->id); ?>" method="POST" action="<?php echo e(route('users.destroy', $user->id)); ?>" style="display: none;">
                                                                <?php echo csrf_field(); ?>
                                                                <?php echo method_field('DELETE'); ?>
                                                            </form>
                                                        <?php endif; ?>
                                                    </td>
                                                <?php endif; ?>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    </div>


            </div>
                
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
    // Chart Arrestations
    new Chart(document.getElementById('chartArrestations'), {
        type: 'line',
        data: {
        labels: <?php echo json_encode($arrestationsMonthly->pluck('mois')); ?>,
        datasets: [{
            label: 'Arrestations',
            data: <?php echo json_encode($arrestationsMonthly->pluck('total')); ?>,
            borderColor: 'rgb(75, 192, 192)',
            tension: 0.1
        }]
        }
    });

    // Chart Matériel
    new Chart(document.getElementById('chartMateriel'), {
        type: 'bar',
        data: {
        labels: <?php echo json_encode($materielParType->pluck('type')); ?>,
        datasets: [{
            label: 'Quantité',
            data: <?php echo json_encode($materielParType->pluck('total')); ?>,
            backgroundColor: 'rgba(153, 102, 255, 0.6)'
        }]
        },
        options: {
        scales: { y: { beginAtZero: true } }
        }
    });

    // Leaflet map
    var map = L.map('map').setView([<?php echo e($prison->latitude); ?>, <?php echo e($prison->longitude); ?>], 12);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy; OpenStreetMap',
        maxZoom: 18
    }).addTo(map);
    L.marker([<?php echo e($prison->latitude); ?>, <?php echo e($prison->longitude); ?>])
    .addTo(map)
    .bindPopup('<b><?php echo e(addslashes($prison->name)); ?></b><br><?php echo e(addslashes($prison->location)); ?>');
    });
    </script><?php /**PATH C:\Users\EASYTECH AFRICA\Documents\DMC\TOSAOBIKA\resources\views/prisons/detail.blade.php ENDPATH**/ ?>