<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        h2 { text-align: center; text-decoration: underline; }
        .section { margin-bottom: 15px; }
        .bold { font-weight: bold; }
    </style>
</head>
<body>
    <h2>PROCÈS-VERBAL D’ARRESTATION</h2>

    <div class="section">
        <p><span class="bold">PV N° :</span> <?php echo e($pv_number); ?></p>
        <p><span class="bold">Lieu :</span> <?php echo e($poste); ?></p>
        <p><span class="bold">Date :</span> <?php echo e(\Carbon\Carbon::parse($date)->format('d/m/Y')); ?> à <?php echo e($heure); ?></p>
    </div>

    <div class="section">
        <p><span class="bold">Chef de poste :</span> <?php echo e($arrestation->user->name); ?></p>
        <p><span class="bold">Grade / Fonction :</span> <?php echo e($grade); ?></p>
        <p><span class="bold">Matricule :</span> <?php echo e($matricule); ?></p>
    </div>

    <div class="section">
        <h4>Identité du prisonnier :</h4>
        <p><span class="bold">Nom :</span> <?php echo e($prisonnier->nom); ?></p>
        <p><span class="bold">Prénom :</span> <?php echo e($prisonnier->prenom); ?></p>
        <p><span class="bold">Date et lieu de naissance :</span> <?php echo e($prisonnier->date_naissance); ?> à <?php echo e($prisonnier->lieu_naissance); ?></p>
        <p><span class="bold">Nationalité :</span> <?php echo e($prisonnier->nationalite); ?></p>
        <p><span class="bold">Domicile :</span> <?php echo e($prisonnier->adresse ?? 'N/A'); ?></p>
    </div>

    <div class="section">
        <h4>Circonstances de l’arrestation :</h4>
        <p><span class="bold">Date et heure :</span> <?php echo e($arrestation->created_at->format('d/m/Y H:i')); ?></p>
        <p><span class="bold">Lieu :</span> <?php echo e($arrestation->lieu ?? 'N/A'); ?></p>
         <p><span class="bold">Motif :</span></p>
         <ul>
             <?php $__currentLoopData = $arrestation->crimes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crime): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($crime->code); ?> - <?php echo e($crime->libelle); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
         </ul>
        <hr>
        <p>
           <b>
             ### MESURES PRISES
           </b><br>

            - L’individu a été informé de ses droits conformément à la loi en vigueur.  
            - Il a été conduit au Poste de Police de <?php echo e($arrestation->prison->name); ?>, pour être entendu et placé en garde à vue.  
            - Une enquête est en cours sous la direction du parquet près le Tribunal de Grande Instance de [ville].

            Le présent procès-verbal est rédigé pour servir et valoir ce que de droit.
        </p>
    </div>

    <div class="section">
        <p>Fait à <?php echo e($poste); ?>, le <?php echo e(\Carbon\Carbon::parse($date)->format('d/m/Y')); ?></p>
        <p>Signature du Chef de Poste</p><br><br>
        <p>__________________________</p>
        <p><?php echo e($chef); ?> – <?php echo e($grade); ?></p>
    </div>
</body>
</html>
<?php /**PATH C:\Users\EASYTECH AFRICA\Documents\DMC\TOSAOBIKA\resources\views/prisoniers/proces_verbal.blade.php ENDPATH**/ ?>