<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="container mx-auto px-4 py-6">
         <?php $__env->slot('header', null, []); ?> 
            <?php echo $__env->make('reservations.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?> <!-- Crée ce fichier si nécessaire -->
         <?php $__env->endSlot(); ?>

        <a href="<?php echo e(route('reservations.create')); ?>" class="btn btn-primary ">+ Nouvelle réservation</a>
        <h4 style="float:right;width:fit-content;color:#333">Détail de reservation</h4>
        <hr>

        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
            <hr>
        <?php endif; ?>

    <div class="row">
        <div class="col-lg-6">
            <div class="card shadow pdf">
                <div class="card-header">
                    Réservation #<?php echo e($reservation->code); ?>

                </div>
                <div class="card-body">
                    <p><strong>Départ :</strong> <?php echo e($reservation->depart); ?></p>
                    <p><strong>Destination :</strong> <?php echo e($reservation->destination); ?></p>
                    <p><strong>Date départ :</strong> <?php echo e($reservation->date_depart); ?></p>
                    <p><strong>Heure départ :</strong> <?php echo e($reservation->heure_depart); ?></p>
                    <p><strong>Places :</strong> <?php echo e($reservation->place); ?></p>
                    <p><strong>Solde :</strong> <?php echo e($reservation->solde); ?> F</p>
                    <p><strong>Distance :</strong> <?php echo e($reservation->distance); ?> km</p>
                    <p><strong>Durée :</strong> <?php echo e($reservation->duration); ?></p>
                    <p><strong>Détails :</strong> <?php echo e($reservation->detail); ?></p>
                    <p><strong>Statut :</strong> <?php echo e($reservation->statut ? 'Confirmé' : 'Non confirmé'); ?></p>
                    <p><strong>Desservi :</strong> <?php echo e($reservation->desservi ? 'Oui' : 'Non'); ?></p>

                    <hr>

                    <h5><strong>Client</strong></h5>
                    <p><strong>Identifiant:</strong> <?php echo e($reservation->user->name ?? 'N/A'); ?> (ID: <?php echo e($reservation->id_user); ?>)</p>
                    <p><strong>Téléphone  :</strong> <?php echo e($reservation->telephone); ?></p>
                    <hr>
                    <h5><strong>Chauffeur</strong></h5>
                    <p><strong>Identifiant:</strong><?php echo e($reservation->chauffeur->name ?? 'Non assigné'); ?></p>
                    <p><strong>Téléphone  :</strong> <?php echo e($reservation->chauffeur->telephone); ?></p>
                    <hr>
                    <h5><strong>Véhicule</strong></h5>
                    <p><?php echo e($reservation->car->marque ?? 'Non défini'); ?> - <?php echo e($reservation->car->immatriculation ?? ''); ?></p>
                    <h5><strong>Gamme</strong></h5>
                    <p><?php echo e($reservation->gamme->libelle ?? $reservation->gamme_libelle); ?> - <?php echo e($reservation->gamme_tarif); ?> F</p>
                    <?php if($reservation->gamme_image): ?>
                        <img src="<?php echo e(asset('storage/' . $reservation->gamme_image)); ?>" alt="Image gamme" style="max-width: 150px;">
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <table class="table-auto w-full border-collapse border border-gray-300 shadow">
                <thead>
                    <tr class="bg-gray-200">
                        <th class="border px-4 py-2">#</th>
                        <th class="border px-4 py-2">Montant (XAF)</th>
                        <th class="border px-4 py-2">Valide</th>
                        <th class="border px-4 py-2">Sens</th>
                        <th class="border px-4 py-2">Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    <?php $__currentLoopData = $finances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $finance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="border px-4 py-2"><?php echo e($i++); ?></td>
                            
                            <td class="border px-4 py-2"><?php echo e(number_format($finance->montant, 0, ',', ' ')); ?></td>
                            
                            <td class="border px-4 py-2">
                                <span class="badge <?php echo e($finance->valide ? 'bg-green-500' : 'bg-red-500'); ?> text-white px-2 py-1 rounded text-xs">
                                    <?php echo e($finance->valide ? 'Oui' : 'Non'); ?>

                                </span>
                            </td>
                            <td class="border px-4 py-2">
                                
                                    <span class="badge <?php echo e($finance->sens=='sortie' ? 'bg-red-500' : 'bg-green-500'); ?> text-white px-2 py-1 rounded text-xs">
                                        <?php echo e($finance->sens); ?>

                                    </span>
                               
                                
                            </td>
                            <td class="border px-4 py-2">
                                <?php echo e(\Carbon\Carbon::parse($finance->date_operation)->format('d/m/Y H:i')); ?>

                            </td>
                            
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<?php /**PATH C:\Users\EASYTECH AFRICA\Documents\DMC\EVOX-BACK\resources\views/reservations/show.blade.php ENDPATH**/ ?>