<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\CarController;
use App\Http\Controllers\GammeController;
use App\Http\Controllers\MaterielPrisonController;
use App\Http\Controllers\OperationController;
use App\Http\Controllers\ReservationController;
use App\Http\Controllers\ParametreController;
use App\Http\Controllers\FinanceController;
use App\Http\Controllers\PrisonController;
use App\Http\Controllers\PrisonierController;
use App\Http\Controllers\CrimeController;
use App\Http\Controllers\VilleController;
use App\Http\Controllers\ArrondissementController;
use App\Http\Controllers\QuartierController;
use App\Http\Controllers\ZoneController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ApiController;

Route::get('/', function () {
    return view('welcome');
});

 Route::get('/phone', [ApiController::class, 'phone']);
 Route::get('/user_insert', [ApiController::class, 'user_insert']);
 Route::get('/update_user_statut', [ApiController::class, 'update_user_statut']);
 Route::get('/category_car', [ApiController::class, 'category_car']);
 Route::get('/users_by_id', [ApiController::class, 'users_by_id']);
 Route::get('/add_position_user', [ApiController::class, 'add_position_user']);
 Route::get('/prix_itineraire', [ApiController::class, 'prix_itineraire']);
 Route::get('/get_solde_by_id_user', [ApiController::class, 'get_solde_by_id_user']);
 Route::get('/resa_desservi', [ApiController::class, 'resa_desservi']);
 Route::get('/search_car_available', [ApiController::class, 'search_car_available']);

// Route::get('/dashboard', function () {
//     return view('dashboard');
// })->middleware(['auth', 'verified'])->name('dashboard');

 Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Gestion des utilisateurs
Route::middleware(['auth'])->group(function () {
    //Route::resource('users', UserController::class)->name('users.index');
    Route::get('/users', [UserController::class, 'index'])->name('users.index');
    Route::get('/cc', [UserController::class, 'cc'])->name('users.cc');
    Route::get('/cpa', [UserController::class, 'cpa'])->name('users.cpa');
    Route::get('/cpq', [UserController::class, 'cpq'])->name('users.cpq');
    Route::get('/cp', [UserController::class, 'cp'])->name('users.cp');
    Route::get('/geolier', [UserController::class, 'geolier'])->name('users.geolier');
    Route::get('/user/stat', [UserController::class, 'stat'])->name('users.stat');
    Route::get('/users/create', [UserController::class, 'create'])->name('users.create');

    Route::get('/users/edit/{id}', [UserController::class, 'edit'])->name('users.edit');

    Route::post('/users', [UserController::class, 'store'])->name('users.store');
    Route::put('/users/{user}', [UserController::class, 'update'])->name('users.update');

    Route::delete('/users/bulk-delete', [UserController::class, 'bulkDelete'])->name('users.bulk-delete');
    Route::delete('/users/{id}', [UserController::class, 'destroy'])->name('users.destroy');


})->middleware(['auth', 'verified']);

Route::middleware(['auth'])->group(function () {
    //Route::resource('users', UserController::class)->name('users.index');
   
    Route::get('/materiels', [MaterielPrisonController::class, 'index'])->name('materiels.index');
    Route::get('/operations', [OperationController::class, 'index'])->name('operations.index');

    Route::get('/materiels/create', [MaterielPrisonController::class, 'create'])->name('materiels.create');
    Route::get('/operations/create', [OperationController::class, 'create'])->name('operations.create');

    Route::get('/materiels/edit/{id}', [MaterielPrisonController::class, 'edit'])->name('materiels.edit');
    Route::get('/operations/edit/{id}', [OperationController::class, 'edit'])->name('operations.edit');

    Route::get('/reservations/show/{id}', [ReservationController::class, 'show'])->name('reservations.show');

    Route::post('/materiels', [MaterielPrisonController::class, 'store'])->name('materiels.store');
    Route::post('/operations', [OperationController::class, 'store'])->name('operations.store');

    Route::put('/materiels/{id}', [MaterielPrisonController::class, 'update'])->name('materiels.update');
    Route::put('/operations/{id}', [OperationController::class, 'update'])->name('operations.update');

    Route::delete('/reservations/bulk-delete', [ReservationController::class, 'bulkDelete'])->name('reservations.bulk-delete');
    Route::delete('/reservations/{id}', [ReservationController::class, 'destroy'])->name('reservations.destroy');

})->middleware(['auth', 'verified']);

Route::middleware(['auth'])->group(function () {
    //Route::resource('users', UserController::class)->name('users.index');
    Route::get('/prisons', [PrisonController::class, 'index'])->name('prisons.index');
    Route::get('/prisons/cc', [PrisonController::class, 'cc'])->name('prisons.cc');
    Route::get('/prisons/cpa', [PrisonController::class, 'cpa'])->name('prisons.cpa');
    Route::get('/prisons/cpq', [PrisonController::class, 'cpq'])->name('prisons.cpq');
    Route::get('/prisons/pa', [PrisonController::class, 'pa'])->name('prisons.pa');

    Route::get('/prisons/create/{type}', [PrisonController::class, 'create'])->name('prisons.create');
    Route::get('/prisons/edit/{id}', [PrisonController::class, 'edit'])->name('prisons.edit');

    Route::delete('/finances/bulk-delete', [FinanceController::class, 'bulkDelete'])->name('finances.bulk-delete');
    Route::delete('/finances/{id}', [FinanceController::class, 'destroy'])->name('finances.destroy');

    Route::post('/prisons', [PrisonController::class, 'store'])->name('prisons.store');

    Route::put('/prisons/{id}', [PrisonController::class, 'update'])->name('prisons.update');

     Route::get('/prisons/stat', [PrisonController::class, 'stat'])->name('prisons.stat');

})->middleware(['auth', 'verified']);

Route::middleware(['auth'])->group(function () {
    //Route::resource('users', UserController::class)->name('users.index');
    Route::get('/prisoniers', [PrisonierController::class, 'index'])->name('prisoniers.index');
    Route::get('/prisons/cc', [PrisonController::class, 'cc'])->name('prisons.cc');
    Route::get('/prisons/cpa', [PrisonController::class, 'cpa'])->name('prisons.cpa');
    Route::get('/prisons/cpq', [PrisonController::class, 'cpq'])->name('prisons.cpq');
    Route::get('/prisons/pa', [PrisonController::class, 'pa'])->name('prisons.pa');

    Route::get('/prisoniers/create', [PrisonierController::class, 'create'])->name('prisoniers.create');
    Route::get('/prisons/edit/{id}', [PrisonController::class, 'edit'])->name('prisons.edit');
    Route::get('/prisons/detail/{id}', [PrisonController::class, 'detail'])->name('prison.detail');
    Route::get('/prisoniers/detail/{id}', [PrisonierController::class, 'detail'])->name('prisonier.detail');

    Route::delete('/finances/bulk-delete', [FinanceController::class, 'bulkDelete'])->name('finances.bulk-delete');
    Route::delete('/finances/{id}', [FinanceController::class, 'destroy'])->name('finances.destroy');

    Route::post('/prisoniers', [PrisonierController::class, 'store'])->name('prisoniers.store');

    Route::put('/prisons/{id}', [PrisonController::class, 'update'])->name('prisons.update');

     Route::get('/prisons/stat', [PrisonController::class, 'stat'])->name('prisons.stat');

})->middleware(['auth', 'verified']);

Route::middleware(['auth'])->group(function () {
    //Route::resource('users', UserController::class)->name('users.index');
    Route::get('/parametres', [ParametreController::class, 'index'])->name('parametres.index');
    Route::get('/parametres/villes/index', [ParametreController::class, 'ville_index'])->name('parametres.villes.index');
    Route::get('/parametres/villes/create', [ParametreController::class, 'ville_create'])->name('parametres.villes.create');

})->middleware(['auth', 'verified']);

Route::middleware(['auth'])->group(function () {
    //Route::resource('users', UserController::class)->name('users.index');
    Route::get('/crimes', [CrimeController::class, 'index'])->name('crimes.index');
    Route::get('/prisoniers/arrestation', [PrisonierController::class, 'prisonier_arrestation'])->name('prisoniers.arrestation.index');
    Route::get('/crimes/create', [CrimeController::class, 'create'])->name('crimes.create');
    Route::get('/prisonier/arrestation/create', [PrisonierController::class, 'prisonier_arrestation_create'])->name('prisoniers.arrestation.create');
    Route::get('/prisonier/arrestation/create/{id}', [PrisonierController::class, 'prisonier_arrestation_create_prisonier'])->name('prisoniers.arrestation.create.prisonier');
    Route::get('/crimes/edit/{id}', [CrimeController::class, 'edit'])->name('crimes.edit');
    Route::get('/prisonier/arrestation/edit/{id}', [PrisonierController::class, 'prisonier_arrestation_edit'])->name('prisonier.arrestation.edit');
    Route::get('/prisonier/arrestation/pdf/{id}', [PrisonierController::class, 'generate'])->name('prisonier.arrestation.generate');
    Route::get('/crimes/detail/{id}', [CrimeController::class, 'detail'])->name('crimes.detail');
    Route::post('/crimes', [CrimeController::class, 'store'])->name('crimes.store');
    Route::post('/prisoniers/arrestation/store', [PrisonierController::class, 'prisonier_arrestation_store'])->name('prisoniers.arrestation.store');
    Route::post('/crimes/photo', [CrimeController::class, 'photo_store'])->name('crimes.photo.store');
    Route::post('/crimes/prisoniers', [CrimeController::class, 'prisonier_store'])->name('crimes.prisoniers.store');
    Route::put('/crimes/{id}', [CrimeController::class, 'update'])->name('crimes.update');
    Route::put('/prisoniers/arrestation/{id}', [PrisonierController::class, 'prisonier_arrestation_update'])->name('prisonier.arrestation.update');
    

})->middleware(['auth', 'verified']);


// Gestion des vehicules

Route::middleware(['auth'])->group(function () {
    //Route::resource('users', UserController::class)->name('users.index');
    Route::get('/cars', [CarController::class, 'index'])->name('cars.index');
    Route::get('/cars/create', [CarController::class, 'create'])->name('cars.create');
    Route::get('/cars/stat', [CarController::class, 'stat'])->name('cars.stat');

    Route::get('/cars/edit/{id}', [CarController::class, 'edit'])->name('cars.edit');

    Route::post('/cars', [CarController::class, 'store'])->name('cars.store');
    Route::put('/cars/{id}', [CarController::class, 'update'])->name('cars.update');

    Route::delete('/cars/bulk-delete', [CarController::class, 'bulkDelete'])->name('cars.bulk-delete');
    Route::delete('/cars/{id}', [CarController::class, 'destroy'])->name('cars.destroy');

    Route::post('/cars/{vehicule}/affecter-chauffeur', [CarController::class, 'affecterChauffeur'])->name('cars.affecterChauffeur');


    // gamme de vehicule
    Route::get('/gammes', [GammeController::class, 'index'])->name('gammes.index');
    Route::get('/gammes/create', [GammeController::class, 'create'])->name('gammes.create');
    Route::get('/gammes/affectation', [GammeController::class, 'affectation'])->name('gammes.affectation');

    Route::get('/gammes/edit/{id}', [GammeController::class, 'edit'])->name('gammes.edit');

    Route::post('/gammes', [GammeController::class, 'store'])->name('gammes.store');
    Route::post('/gammes/affecter', [GammeController::class, 'affectergamme'])->name('cars.affecter-gamme');
    Route::put('/gammes/{id}', [GammeController::class, 'update'])->name('gammes.update');

    Route::delete('/gammes/bulk-delete', [GammeController::class, 'bulkDelete'])->name('gammes.bulk-delete');
    Route::delete('/gammes/{id}', [GammeController::class, 'destroy'])->name('gammes.destroy');


    Route::get('villes',  [VilleController::class, 'index'])->name('ville.index');
    Route::get('/ville/create', [VilleController::class, 'create'])->name('ville.create');
    Route::get('/ville/edit/{id}', [VilleController::class, 'edit'])->name('ville.edit');
    Route::post('/villes', [VilleController::class, 'store'])->name('ville.store');
    Route::put('/villes/{id}', [VilleController::class, 'update'])->name('ville.update');

    Route::get('zones',  [ZoneController::class, 'index'])->name('zone.index');
    Route::get('/zone/create', [ZoneController::class, 'create'])->name('zone.create');
    Route::get('/zone/edit/{id}', [ZoneController::class, 'edit'])->name('zone.edit');
    Route::post('/zones', [ZoneController::class, 'store'])->name('zone.store');
    Route::put('/zones/{id}', [ZoneController::class, 'update'])->name('zone.update');

    Route::get('arrondissements',  [ArrondissementController::class, 'index'])->name('arrondissement.index');
    Route::get('/arrondissement/create', [ArrondissementController::class, 'create'])->name('arrondissement.create');
    Route::get('/arrondissement/edit/{id}', [ArrondissementController::class, 'edit'])->name('arrondissement.edit');
    Route::post('/arrondissements', [ArrondissementController::class, 'store'])->name('arrondissement.store');
    Route::put('/arrondissements/{id}', [ArrondissementController::class, 'update'])->name('arrondissement.update');

    Route::get('quartiers',  [QuartierController::class, 'index'])->name('quartier.index');
    Route::get('/quartier/create', [QuartierController::class, 'create'])->name('quartier.create');
    Route::get('/quartier/edit/{id}', [QuartierController::class, 'edit'])->name('quartier.edit');
    Route::post('/quartiers', [QuartierController::class, 'store'])->name('quartier.store');
    Route::put('/quartiers/{id}', [QuartierController::class, 'update'])->name('quartier.update');

})->middleware(['auth', 'verified']);




require __DIR__.'/auth.php';
