<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('users.navigation')
        </x-slot>

        <a href="{{ route('users.create') }}" class="btn btn-primary mb-3">+ Nouveau</a>
        <h4 style="float:right;width:fit-content;color:#333">{{$title}}</h4>
        <hr>
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-info text-white shadow">
                    <div class="card-body">Total: <strong style="font-size: 20px;font-weight: bold">{{ $usersCount }}</strong></div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-success text-white shadow">
                    <div class="card-body">Total rôle: <strong style="font-size: 20px;font-weight: bold">5</strong></div>
                </div>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-md-4">
                <div class="form-group" style="height: 400px;overflow-y: scroll">
                    <div class="card mb-2">
                        <div class="card-header">Répartition par Arrondissement</div>
                        <ul class="list-group list-group-flush">
                            @foreach($usersByArrondissement as $arr => $total)
                                <li class="list-group-item" style="font-size: 20px;font-weight: bold">{{ $arr }}: {{ $total }}</li>
                            @endforeach
                        </ul>
                    </div>
                    <div class="card">
                        <div class="card-header">Répartition par Ville</div>
                        <ul class="list-group list-group-flush">
                            @foreach($usersByVille as $ville => $total)
                                <li class="list-group-item" style="font-size: 20px;font-weight: bold">{{ $ville }}: {{ $total }}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-md-8">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="card shadow" style="height: 400px;overflow-y: scroll">
                            <div class="card-header"><h4>Créations par mois</h4></div>
                            <div class="card-body">
                                <canvas id="usersByMonthChart" class="mb-5" style="display: block;margin: 0 auto"></canvas>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card shadow" style="height: 400px;overflow-y: scroll">
                            <div class="card-header"><h4>Créations par rôle</h4></div>
                            <div class="card-body" style="height: 300px;overflow-y: scroll">
                                <canvas id="usersByRoleChart" class="mb-5" style="display: block;margin: 0 auto"></canvas>
                            </div>
                            
                        </div>
                        
                    </div>

                    
                </div>
            </div>
        </div>
        

    </div>
</x-app-layout>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        const roleCtx = document.getElementById('usersByRoleChart');
        new Chart(roleCtx, {
            type: 'pie',
            data: {
                labels: {!! json_encode($usersByRole->keys()) !!},
                datasets: [{
                    label: 'Par Rôle',
                    data: {!! json_encode($usersByRole->values()) !!},
                    backgroundColor: ['#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b']
                }]
            }
        });

        const monthCtx = document.getElementById('usersByMonthChart');
        new Chart(monthCtx, {
            type: 'line',
            data: {
                labels: {!! json_encode($usersByMonth->keys()) !!},
                datasets: [{
                    label: 'Créations mensuelles',
                    data: {!! json_encode($usersByMonth->values()) !!},
                    borderColor: '#36b9cc',
                    fill: false
                }]
            }
        });
    </script>


