<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('users.navigation')
        </x-slot>

        <a href="{{ route('users.create') }}" class="btn btn-primary shadow">+ Nouveau</a>
        <h4 style="float:right;width:fit-content;color:#333">{{$title}}</h4>
        <hr>

        <table class="table table-hover table-bordered" id="myTable">
            <thead>
                <tr>
                    <th>Nom</th>
                    <th>Email</th>
                    <th>Téléphone</th>
                    <th>Rôle</th>
                    <th>Prison</th>
                    <th>Quartier</th>
                    <th>Arrondissement</th>
                    <th>Zone</th>
                    <th>Ville</th>
                    @if(Auth::user()->role === 'admin')
                        <th>Action</th>
                    @endif
                </tr>
            </thead>
            <tbody>
                @foreach($users as $user)
                    <tr>
                        <td>{{ $user->name }}</td>
                        <td>{{ $user->email }}</td>
                        <td>{{ $user->phone_number }}</td>
                        <td>{{ $user->role }}</td>
                        <td>{{ $user->prison->name ?? 'Aucune' }}</td>
                        <td>{{ $user->prison->quartier->name ?? '—' }}</td>
                        <td>{{ $user->prison->quartier->arrondissement->name ?? '—' }}</td>
                        <td>{{ $user->prison->quartier->arrondissement->zone->name ?? '—' }}</td>
                        <td>{{ $user->prison->quartier->arrondissement->zone->ville->name ?? '—' }}</td>
                         @if(Auth::user()->role === 'admin')
                            <td>
                                <a href="{{ route('users.edit', $user->id) }}">✏️</a>

                                 @if(Auth::id() !== $user->id)
                                    <button onclick="confirmDelete({{ $user->id }})">🗑️</button>

                                    <form id="delete-form-{{ $user->id }}" method="POST" action="{{ route('users.destroy', $user->id) }}" style="display: none;">
                                        @csrf
                                        @method('DELETE')
                                    </form>
                                @endif
                            </td>
                        @endif
                    </tr>
                @endforeach
            </tbody>
        </table>


    </div>
</x-app-layout>

<script>
    function confirmDelete(userId) {
        Swal.fire({
            title: 'Êtes-vous sûr ?',
            text: "Cette action est irréversible.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Oui, supprimer',
            cancelButtonText: 'Annuler'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('delete-form-' + userId).submit();
            }
        });
    }
</script>

<script>
    document.getElementById('check-all').addEventListener('change', function () {
        const checkboxes = document.querySelectorAll('.checkbox');
        checkboxes.forEach(cb => cb.checked = this.checked);
    });

    document.getElementById('bulk-delete-btn').addEventListener('click', function () {
        const form = document.getElementById('bulk-delete-form');
        const selected = form.querySelectorAll('.checkbox:checked');

        if (selected.length === 0) {
            Swal.fire('Aucun élément sélectionné', 'Veuillez sélectionner au moins un utilisateur.', 'info');
            return;
        }

        Swal.fire({
            title: 'Confirmer la suppression ?',
            text: "Les utilisateurs sélectionnés seront supprimés.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Oui, supprimer',
            cancelButtonText: 'Annuler',
            confirmButtonColor: '#d33'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    });
</script>


