<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2rem !important;
    }
</style>

<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('users.navigation')
        </x-slot>

        <div style="
                display: flex;
            justify-content: space-between;
            flex-wrap: nowrap;
            align-content: center;
            align-items: center;
        "> 
            <a href="{{ route('users.index') }}" class="btn btn-primary mb-3">+ Liste</a>
            <h4 style="float:right;width:fit-content;color:#333">Modification utilisateur</h4>
            <hr>

           <div class="caption" style="
                display: flex;
                align-items: center;
                justify-content: flex-end;
                align-content: center;
           ">
                
                @if ($user->image)
                    <div class="mr-2" style="float:right">
                        <img src="{{ asset('storage/' . $user->image) }}" alt="Image de {{ $user->nom }}" style="width: auto; height: 80px;" class="rounded shadow">
                    </div>
                @endif
                <h3 style="float:right">
                    {{$user->nom}}
                </h3>
           </div>
        </div>

        <hr>

        <div class="container">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3 shadow">
                <form action="{{ route('users.update', $user->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="row">
                        <div class="col-lg-4">
                            <!-- Nom -->
                            <div class="mb-1">
                                <label for="name" class="form-label">Nom complet</label>
                                <input type="text" name="name" class="form-control" value="{{ old('name', $user->name) }}" required>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <!-- Email -->
                            <div class="mb-1">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" name="email" class="form-control" value="{{ old('email', $user->email) }}">
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <!-- Téléphone -->
                            <div class="mb-1">
                                <label for="phone" class="form-label">Téléphone</label>
                                <input type="text" name="phone_number" class="form-control" value="{{ old('phone_number', $user->phone_number) }}" required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-4">
                            <!-- Rôle -->
                            <div class="mb-1">
                                <label for="role" class="form-label">Rôle</label>
                                <select name="role" class="form-select" required>
                                    <option value="">Sélectionner un rôle</option>
                                    @foreach(['admin', 'cpa', 'cpq', 'cp', 'ct', 'cc', 'geolier'] as $role)
                                        <option value="{{ $role }}" {{ $user->role === $role ? 'selected' : '' }}>
                                            {{ strtoupper($role) }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <!-- Prison -->
                            <div class="mb-1">
                                <label for="assigned_prison_id" class="form-label">Prison assignée</label>
                                <select name="assigned_prison_id" class="form-select">
                                    <option value="">Aucune</option>
                                    @foreach($prisons as $prison)
                                        <option value="{{ $prison->id }}" {{ $user->assigned_prison_id == $prison->id ? 'selected' : '' }}>
                                            {{ $prison->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <!-- Photo -->
                            <div class="mb-1">
                                <label for="photo" class="form-label">Photo</label>
                                <input type="file" name="photo" class="form-control">
                                @if ($user->photo)
                                    <div class="mt-2">
                                        <img src="{{ asset('storage/' . $user->photo) }}" width="80" class="rounded shadow-sm">
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>

                   

                    <button type="submit" class="btn btn-primary mt-2">Mettre à jour</button>
                </form>
            </div>
                
        </div>
    </div>
</x-app-layout>

