<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('reservations.navigation') <!-- Crée ce fichier si nécessaire -->
        </x-slot>

        <a href="{{ route('reservations.create') }}" class="btn btn-primary ">+ Nouvelle réservation</a>
        <h4 style="float:right;width:fit-content;color:#333">Statistique de reservation</h4>
        <hr>
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card text-white bg-primary shadow">
                    <div class="card-body">
                        <h5 class="card-title">📦 Réservations totales</h5>
                        <h3>{{ $totalReservations }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-success shadow">
                    <div class="card-body">
                        <h5 class="card-title">🟢 Desservies</h5>
                        <h3>{{ $totalDesservies }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-danger shadow">
                    <div class="card-body">
                        <h5 class="card-title">🔴 Non desservies</h5>
                        <h3>{{ $totalNonDesservies }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-warning ">
                    <div class="card-body">
                        <h5 class="card-title">💰 Revenu total</h5>
                        <h3>{{ number_format($revenuTotal, 0, ',', ' ') }} FCFA</h3>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-4 mb-4">
                <div class="card shadow mb-2" >
                    <div class="card-header"><h4>📅 Réservations par mois</h4></div>
                    <div class="card-body">
                        <canvas id="reservationsMois"></canvas>
                    </div>
                </div>
                
            </div>
            <div class="col-lg-4">
                <div class="card shadow">
                    <div class="card-header"> <h4>💰 Revenus mensuels</h4></div>
                    <div class="card-body">
                        <canvas id="revenusChart"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card shadow">
                    <div class="card-header"> <h4>🟢 Réservations desservies vs non desservies</h4></div>
                    <div class="card-body">
                        <canvas id="desserviChart"></canvas>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3">
                <div class="card shadow" style="height: 388px">
                    <div class="card-header"> <h4>📊 Répartition par statut</h4></div>
                    <div class="card-body">
                        <canvas id="statutChart"></canvas>
                    </div>
                </div>
            </div>

            

            <div class="col-lg-3">
                <div class="card shadow" style="height: 388px">
                    <div class="card-header"> <h4>🚘 Répartition par gamme</h4></div>
                    <div class="card-body">
                        <canvas id="gammeChart"></canvas>
                    </div>
                </div>
            </div>

        </div>
    </div>
</x-app-layout>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const reservationsMois = @json($reservationsParMois);
    const labelsMois = reservationsMois.map(item => item.mois);
    const dataMois = reservationsMois.map(item => item.total);

    new Chart(document.getElementById('reservationsMois'), {
        type: 'line',
        data: {
            labels: labelsMois,
            datasets: [{
                label: 'Nombre de réservations',
                data: dataMois,
                borderColor: 'blue',
                fill: false
            }]
        }
    });

    const statuts = @json($reservationsParStatut);
    new Chart(document.getElementById('statutChart'), {
        type: 'pie',
        data: {
            labels: statuts.map(s => s.statut),
            datasets: [{
                data: statuts.map(s => s.total),
                backgroundColor: ['#f39c12', '#27ae60', '#c0392b']
            }]
        }
    });

    const revenus = @json($revenusParMois);
    new Chart(document.getElementById('revenusChart'), {
        type: 'bar',
        data: {
            labels: revenus.map(r => r.mois),
            datasets: [{
                label: 'Revenus (FCFA)',
                data: revenus.map(r => r.revenus),
                backgroundColor: 'green'
            }]
        }
    });

    const gammes = @json($gammes);
    new Chart(document.getElementById('gammeChart'), {
        type: 'doughnut',
        data: {
            labels: gammes.map(g => g.gamme_libelle),
            datasets: [{
                data: gammes.map(g => g.total),
                backgroundColor: ['#3498db', '#e74c3c', '#9b59b6', '#1abc9c']
            }]
        }
    });

    const desservis = @json($desservis);

new Chart(document.getElementById('desserviChart'), {
    type: 'bar',
    data: {
        labels: desservis.map(d => d.statut_desservi),
        datasets: [{
            label: 'Nombre de réservations',
            data: desservis.map(d => d.total),
            backgroundColor: [ '#e74c3c','#2ecc71']
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: {
                display: false
            },
            title: {
                display: true,
                text: 'Comparaison Desservi / Non desservi'
            }
        },
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

</script>
