<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('reservations.navigation') <!-- Crée ce fichier si nécessaire -->
        </x-slot>

        <a href="{{ route('reservations.create') }}" class="btn btn-primary ">+ Nouvelle réservation</a>
        <h4 style="float:right;width:fit-content;color:#333">Détail de reservation</h4>
        <hr>

        @if (session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
            <hr>
        @endif

    <div class="row">
        <div class="col-lg-6">
            <div class="card shadow pdf">
                <div class="card-header">
                    Réservation #{{ $reservation->code }}
                </div>
                <div class="card-body">
                    <p><strong>Départ :</strong> {{ $reservation->depart }}</p>
                    <p><strong>Destination :</strong> {{ $reservation->destination }}</p>
                    <p><strong>Date départ :</strong> {{ $reservation->date_depart }}</p>
                    <p><strong>Heure départ :</strong> {{ $reservation->heure_depart }}</p>
                    <p><strong>Places :</strong> {{ $reservation->place }}</p>
                    <p><strong>Solde :</strong> {{ $reservation->solde }} F</p>
                    <p><strong>Distance :</strong> {{ $reservation->distance }} km</p>
                    <p><strong>Durée :</strong> {{ $reservation->duration }}</p>
                    <p><strong>Détails :</strong> {{ $reservation->detail }}</p>
                    <p><strong>Statut :</strong> {{ $reservation->statut ? 'Confirmé' : 'Non confirmé' }}</p>
                    <p><strong>Desservi :</strong> {{ $reservation->desservi ? 'Oui' : 'Non' }}</p>

                    <hr>

                    <h5><strong>Client</strong></h5>
                    <p><strong>Identifiant:</strong> {{ $reservation->user->name ?? 'N/A' }} (ID: {{ $reservation->id_user }})</p>
                    <p><strong>Téléphone  :</strong> {{ $reservation->telephone }}</p>
                    <hr>
                    <h5><strong>Chauffeur</strong></h5>
                    <p><strong>Identifiant:</strong>{{ $reservation->chauffeur->name ?? 'Non assigné' }}</p>
                    <p><strong>Téléphone  :</strong> {{ $reservation->chauffeur->telephone }}</p>
                    <hr>
                    <h5><strong>Véhicule</strong></h5>
                    <p>{{ $reservation->car->marque ?? 'Non défini' }} - {{ $reservation->car->immatriculation ?? '' }}</p>
                    <h5><strong>Gamme</strong></h5>
                    <p>{{ $reservation->gamme->libelle ?? $reservation->gamme_libelle }} - {{ $reservation->gamme_tarif }} F</p>
                    @if ($reservation->gamme_image)
                        <img src="{{ asset('storage/' . $reservation->gamme_image) }}" alt="Image gamme" style="max-width: 150px;">
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <table class="table-auto w-full border-collapse border border-gray-300 shadow">
                <thead>
                    <tr class="bg-gray-200">
                        <th class="border px-4 py-2">#</th>
                        <th class="border px-4 py-2">Montant (XAF)</th>
                        <th class="border px-4 py-2">Valide</th>
                        <th class="border px-4 py-2">Sens</th>
                        <th class="border px-4 py-2">Date</th>
                    </tr>
                </thead>
                <tbody>
                    @php $i = 1; @endphp
                    @foreach ($finances as $finance)
                        <tr>
                            <td class="border px-4 py-2">{{ $i++ }}</td>
                            
                            <td class="border px-4 py-2">{{ number_format($finance->montant, 0, ',', ' ') }}</td>
                            
                            <td class="border px-4 py-2">
                                <span class="badge {{ $finance->valide ? 'bg-green-500' : 'bg-red-500' }} text-white px-2 py-1 rounded text-xs">
                                    {{ $finance->valide ? 'Oui' : 'Non' }}
                                </span>
                            </td>
                            <td class="border px-4 py-2">
                                
                                    <span class="badge {{ $finance->sens=='sortie' ? 'bg-red-500' : 'bg-green-500' }} text-white px-2 py-1 rounded text-xs">
                                        {{ $finance->sens }}
                                    </span>
                               
                                
                            </td>
                            <td class="border px-4 py-2">
                                {{ \Carbon\Carbon::parse($finance->date_operation)->format('d/m/Y H:i') }}
                            </td>
                            
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    </div>
</x-app-layout>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
