<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('reservations.navigation')
        </x-slot>

        <a href="{{ route('reservations.index') }}" class="btn btn-primary mb-3">← Liste des réservations</a>
        <h4 style="float:right;width:fit-content;color:#333">Modification de la réservation</h4>
        <hr>

        @if ($errors->any())
            <div class="alert alert-danger my-3">
                <ul class="list-disc pl-5">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="p-3 shadow bg-white">
        <form method="POST" action="{{ route('reservations.update', $reservation->id) }}" class="space-y-4">
            @csrf
            @method('PUT')

            <div class="row">
                <div class="col-md-4">
                    <label>Départ de :</label>
                    <input type="text" id="depart" name="depart" value="{{ old('depart', $reservation->depart) }}" class="form-control" required>

                    <label class="mt-3">Destination de :</label>
                    <input type="text" id="destination" name="destination" value="{{ old('destination', $reservation->destination) }}" class="form-control" required>

                    <label class="mt-3">Date de départ :</label>
                    <input type="date" name="date_depart" value="{{ old('date_depart', $reservation->date_depart) }}" class="form-control" required>

                    <label class="mt-3">Heure de départ :</label>
                    <input type="time" name="heure_depart" value="{{ old('heure_depart', $reservation->heure_depart) }}" class="form-control" required>
                </div>

                <div class="col-md-4">
                    <label for="user_id">Choisir le client :</label>
                    <select name="user_id" id="user_id" class="form-control mb-3" required>
                        <option value="">Sélectionner un utilisateur</option>
                        @foreach ($clients as $user)
                            <option value="{{ $user->id }}" data-phone="{{ $user->telephone }}"
                                {{ old('user_id', $reservation->id_user) == $user->id ? 'selected' : '' }}>
                                {{ $user->nom }} ({{ $user->telephone }})
                            </option>
                        @endforeach
                    </select>

                    <label for="gamme_id">Gamme de véhicule :</label>
                    <select name="gamme_id" id="gamme_id" class="form-control mb-3" required>
                        <option value="">Sélectionner une gamme</option>
                        @foreach ($gammes as $gamme)
                            <option value="{{ $gamme->id }}" data-solde="{{ $gamme->tarif }}"
                                {{ old('gamme_id', $reservation->gamme_id) == $gamme->id ? 'selected' : '' }}>
                                {{ $gamme->libelle }}
                            </option>
                        @endforeach
                    </select>

                    <label>Nombre de places :</label>
                    <input type="number" name="place" value="{{ old('place', $reservation->place) }}" class="form-control" required>

                    <label class="mt-3">Détails :</label>
                    <textarea name="detail" class="form-control">{{ old('detail', $reservation->detail) }}</textarea>
                </div>

                <div class="col-md-4">
                    <label class="">Téléphone :</label>
                    <input type="text" id="telephone" readonly name="telephone" value="{{ old('telephone', $reservation->telephone) }}" class="form-control mb-3" required>

                    <label for="solde">Solde :</label>
                    <input type="number" readonly name="solde" id="solde" value="{{ old('solde', $reservation->solde) }}" class="form-control mb-3">

                    <label for="duration">Durée :</label>
                    <input type="text" readonly name="duration" id="duration" value="{{ old('duration', $reservation->duration) }}" class="form-control mb-3">

                    <label for="distance">Distance :</label>
                    <input type="text" readonly name="distance" id="distance" value="{{ old('distance', $reservation->distance) }}" class="form-control mb-3">
                </div>
            </div>

            <div class="row d-none">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Latitude Départ :</label>
                        <input type="text" id="latitude" value="{{ old('latitude', $reservation->latitude1) }}" name="latitude" class="form-control" readonly>
                    </div>

                    <div class="form-group">
                        <label>Longitude Départ :</label>
                        <input type="text" id="longitude" name="longitude" value="{{ old('longitude', $reservation->longitude1) }}" class="form-control" readonly>
                    </div>

                    <div class="form-group">
                        <label>Latitude Destination :</label>
                        <input type="text" id="latitude1" name="latitude1" value="{{ old('latitude1', $reservation->latitude2) }}" class="form-control" readonly>
                    </div>

                    <div class="form-group">
                        <label>Longitude Destination :</label>
                        <input type="text" id="longitude1" name="longitude1" value="{{ old('longitude1', $reservation->longitude2) }}" class="form-control" readonly>
                    </div>
                </div>
            </div>

            <div class="text-right mt-4">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded">Mettre à jour</button>
            </div>
        </form>

        </div>
    </div>
</x-app-layout>


<script
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB5I8129TPu_fP9L2b1mG9OFEcKkajTA_8&libraries=places"
    async defer>
</script>

<script>
    // Fonction d'initialisation
    function initMap(departLatitude,departLongitude,destinationLatitude,destinationLongitude) {
        
        console.log(departLatitude+""+departLongitude+""+destinationLatitude+""+destinationLongitude);

        // Initialise le service DistanceMatrix
        const distanceService = new google.maps.DistanceMatrixService();
        
            // Utilise DistanceMatrix pour calculer la distance et la durée
            distanceService.getDistanceMatrix(
                {
                    origins: [{lat: departLatitude, lng: departLongitude}],  // Latitude et Longitude de départ
                    destinations: [{lat: destinationLatitude, lng: destinationLongitude}],  // Latitude et Longitude de destination
                    travelMode: google.maps.TravelMode.DRIVING,  // Mode de transport (voiture ici)
                    unitSystem: google.maps.UnitSystem.METRIC,  // Utilisation des unités métriques (kilomètres)
                },
                function(response, status) {
                    

                    if (status === 'OK') {
                        const result = response.rows[0].elements[0];
                        const distance = result.distance.text; // Distance au format "X km"
                        const duration = result.duration.text; // Durée au format "Y heures Z minutes"
                        console.log(distance,duration);
                        // Remplir les champs distance et durée
                        document.getElementById('distance').value = distance;
                        document.getElementById('duration').value = duration;
                    } else {
                        console.log('La requête de distance a échoué pour la raison suivante : ' + status);
                    }
                }
            );
    }
</script>


<script>
    function initAutocomplete() {
        const departInput = document.getElementById('depart');
        const latDepartInput = document.getElementById('latitude');
        const lonDepartInput = document.getElementById('longitude');

        const destinationInput = document.getElementById('destination');
        const latDestInput = document.getElementById('latitude1');
        const lonDestInput = document.getElementById('longitude1');

        // Autocomplétion pour "Départ"
        const departAutocomplete = new google.maps.places.Autocomplete(departInput, {
            types: ['establishment'], 
            componentRestrictions: { country: "cg" }
        });

        departAutocomplete.addListener('place_changed', function () {
            const place = departAutocomplete.getPlace();

            if (place) {
                // Remplir l’input avec le nom uniquement pour le "Départ"
                departInput.value = place.name || '';

                // Extraire la latitude et la longitude pour "Départ"
                if (place.geometry && place.geometry.location) {
                    latDepartInput.value = place.geometry.location.lat();
                    lonDepartInput.value = place.geometry.location.lng();
                    initMap( parseFloat(latDepartInput.value),parseFloat(lonDepartInput.value),parseFloat(latDestInput.value),parseFloat(lonDepartInput.value));
                }
            }
        });
         // Autocomplétion pour "Destination"
         const destinationAutocomplete = new google.maps.places.Autocomplete(destinationInput, {
            types: ['establishment'], 
            componentRestrictions: { country: "cg" }
        });

        destinationAutocomplete.addListener('place_changed', function () {
            const place = destinationAutocomplete.getPlace();

            if (place) {
                // Remplir l’input avec le nom uniquement pour la "Destination"
                destinationInput.value = place.name || '';

                // Extraire la latitude et la longitude pour "Destination"
                if (place.geometry && place.geometry.location) {
                    latDestInput.value = place.geometry.location.lat();
                    lonDestInput.value = place.geometry.location.lng();
                    initMap( parseFloat(latDepartInput.value),parseFloat(lonDepartInput.value),parseFloat(latDestInput.value),parseFloat(lonDepartInput.value));
                }
            }
        });

        
    }

    document.addEventListener('DOMContentLoaded', initAutocomplete);
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const userSelect = document.getElementById('user_id');
        const phoneInput = document.getElementById('telephone');

        userSelect.addEventListener('change', function () {
            const selectedOption = this.options[this.selectedIndex];
            const phone = selectedOption.getAttribute('data-phone');
            phoneInput.value = phone || '';
        });
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const gammeSelect = document.getElementById('gamme_id');
        const soldeInput = document.getElementById('solde');

        gammeSelect.addEventListener('change', function () {
            const selectedOption = this.options[this.selectedIndex];
            const solde = selectedOption.getAttribute('data-solde');
            soldeInput.value = solde || '';
        });
    });
</script>
