{{-- CSS --}}

<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('prisons.navigation')
        </x-slot>

        <button class="btn btn-danger shadow" data-bs-toggle="modal" data-bs-target="#createPrisonModal">+ Nouveau</button>
        <h4 style="float:right;width:fit-content;color:#333">{{$title}}</h4>
        <hr>
         <table class="table table-bordered table-striped" id="myTable">
            <thead class="table-dark">
                <tr>
                    <th>Code</th>
                    <th>Nom</th>
                    <th>Type</th>
                    <th>Capacité</th>
                    <th>Responsable</th>
                    <th>Statut</th>
                    <th>Quartier</th>
                    <th>Arrondissement</th>
                    <th>Zone</th>
                    <th>Ville</th>
                    <th>Créé le</th>
                     @if(Auth::user()->role === 'admin')
                        <th>Action</th>
                    @endif
                </tr>
            </thead>
            <tbody>
                @foreach($prisons as $prison)
                    <tr>
                        <td>{{ $prison->code }}</td>
                        <td>{{ $prison->name }}</td>
                        <td>{{ $prison->type }}</td>
                        <td>{{ $prison->capacity }}</td>
                        <td>{{ $prison->user->name }}</td>
                        <td>{{ $prison->is_active=== 1 ? 'Actif' : 'Inactif' }}</td>
                        <td>{{ $prison->quartier->name ?? 'N/A' }}</td>
                        <td>{{ $prison->quartier->arrondissement->name ?? 'N/A' }}</td>
                        <td>{{ $prison->quartier->arrondissement->zone->name ?? 'N/A' }}</td>
                        <td>{{ $prison->quartier->arrondissement->zone->ville->name ?? 'N/A' }}</td>
                        <td>{{ $prison->created_at->format('d/m/Y') }}</td>
                         @if(Auth::user()->role === 'admin')
                            <td>
                                <a href="{{ route('prisons.edit', $prison->id) }}">✏️</a>
                                 
                                <button onclick="confirmDelete({{ $prison->id }})">🗑️</button>

                                <a href="{{ route('prison.detail', $prison->id) }}" >👁️</a>
                               
                            </td>
                        @endif
                    </tr>
                @endforeach
            </tbody>
        </table>

    </div>

</x-app-layout>

    <!-- Modal -->
<div class="modal fade" id="createPrisonModal" tabindex="1" aria-labelledby="createPrisonModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-md"> <!-- Large modal -->
    <div class="modal-header" style="
                background: #000;color: #fff !important;
      ">
      <h5 class="modal-title" id="createPrisonModalLabel" >Veuillez choisir le type</h5>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="background: #fff"></button>
    </div>
    <div class="modal-content">
      <a href="{{ route('prisons.create', ['type' => 'cc']) }}" class="btn btn-default form-control shadow">Commissariat Central (CC)</a>
      <a href="{{ route('prisons.create', ['type' => 'cpa']) }}" class="btn btn-default form-control shadow">Commissariat de Police d'Arrondissement (CPA)</a>
      <a href="{{ route('prisons.create', ['type' => 'cpq']) }}" class="btn btn-default form-control shadow">Commissariat de Police de quartier (CPQ)</a>
      <a href="{{ route('prisons.create', ['type' => 'pa']) }}" class="btn btn-default form-control shadow">Poste avancé</a>
    </div>
  </div>
</div>

<script>
    function confirmDelete(userId) {
        Swal.fire({
            title: 'Êtes-vous sûr ?',
            text: "Cette action est irréversible.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Oui, supprimer',
            cancelButtonText: 'Annuler'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('delete-form-' + userId).submit();
            }
        });
    }
</script>

<script>
    document.getElementById('check-all').addEventListener('change', function () {
        const checkboxes = document.querySelectorAll('.checkbox');
        checkboxes.forEach(cb => cb.checked = this.checked);
    });

    document.getElementById('bulk-delete-btn').addEventListener('click', function () {
        const form = document.getElementById('bulk-delete-form');
        const selected = form.querySelectorAll('.checkbox:checked');

        if (selected.length === 0) {
            Swal.fire('Aucun élément sélectionné', 'Veuillez sélectionner au moins un utilisateur.', 'info');
            return;
        }

        Swal.fire({
            title: 'Confirmer la suppression ?',
            text: "Les utilisateurs sélectionnés seront supprimés.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Oui, supprimer',
            cancelButtonText: 'Annuler',
            confirmButtonColor: '#d33'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    });
</script>


<!-- Bootstrap JS avec Popper -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>




