<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2.5rem !important;
    }
</style>
<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('prisons.navigation')
        </x-slot>


        <a href="{{ route('prisons.index') }}" class="btn btn-danger mb-3">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">Edition commissariat / Poste</h4>
        <hr>


        <div class="container">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3">
                <!-- resources/views/admin/users/create.blade.php -->
                 <div class="card shadow p-4">
                    <form action="{{ route('prisons.update', $prison->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        <div class="row">
                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label class="form-label">Code</label>
                                    <input type="text" name="code" class="form-control" value="{{ old('code', $prison->code) }}">
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label class="form-label">Nom de la prison</label>
                                    <input type="text" name="name" class="form-control" value="{{ old('name', $prison->name) }}" required>
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label class="form-label">Type</label>
                                    <select name="type" class="form-control" required>
                                        <option value="{{ $prison->type }}">{{ $prison->type }}</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label class="form-label">Responsable</label>
                                    <select name="user_id" class="form-control" required>
                                        <option value="">-- Sélectionnez un directeur --</option>
                                        @foreach ($directeurs as $directeur)
                                            <option value="{{ $directeur->id }}" {{ $prison->user_id == $directeur->id ? 'selected' : '' }}>
                                                {{ $directeur->name }} ({{ $directeur->email }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label class="form-label">Téléphone</label>
                                    <input type="text" name="phone" class="form-control" value="{{ old('phone', $prison->phone) }}">
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label class="form-label">Email</label>
                                    <input type="email" name="email" class="form-control" value="{{ old('email', $prison->email) }}">
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label class="form-label">Date d'ouverture</label>
                                    <input type="date" name="date_ouverture" class="form-control" value="{{ old('date_ouverture', $prison->date_ouverture) }}">
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label class="form-label">Statut</label>
                                    <select name="is_active" class="form-control">
                                        <option value="1" {{ $prison->is_active == 1 ? 'selected' : '' }}>Actif</option>
                                        <option value="0" {{ $prison->is_active == 0 ? 'selected' : '' }}>Inactif</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label class="form-label">Latitude</label>
                                    <input type="text" name="latitude" class="form-control" value="{{ old('latitude', $prison->latitude) }}">
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label class="form-label">Longitude</label>
                                    <input type="text" name="longitude" class="form-control" value="{{ old('longitude', $prison->longitude) }}">
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label class="form-label">Capacité</label>
                                    <input type="text" name="capacity" class="form-control" value="{{ old('capacity', $prison->capacity) }}">
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label class="form-label">Adresse</label>
                                    <input type="text" name="location" class="form-control" value="{{ old('location', $prison->location) }}">
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label class="form-label">Quartier</label>
                                    <select name="quartier_id" class="form-control" required>
                                        <option value="">-- Sélectionner --</option>
                                        @foreach($quartiers as $quartier)
                                            <option value="{{ $quartier->id }}" {{ $prison->quartier_id == $quartier->id ? 'selected' : '' }}>
                                                {{ $quartier->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="text-end mt-4">
                            <button type="submit" class="btn btn-primary">Mettre à jour</button>
                        </div>
                    </form>

                </div>

            </div>
                
        </div>
    </div>
</x-app-layout>

