<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2.5rem !important;
    }
    ul#myTab {
        background: #333 !important;
        height: 50px !important;
    }
    a.nav-link {
        background: #333333 !important;

    }
    .nav-tabs .nav-link{
        color: #fff !important;
    }
    a.nav-link.active {
        background: #f3f4f6 !important;
        border-radius: 0 !important;
        color: #000 !important;
    }
</style>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>

<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('prisons.navigation')
        </x-slot>


        <a href="{{ route('prisons.index') }}" class="btn btn-danger mb-3">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">Détail crime</h4>
        <hr>


        <div class="container">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3">
                <!-- resources/views/admin/users/create.blade.php -->
                 <div class="card shadow p-4">
                    <div class="row">
                        <div class="col-lg-6">
                            <h4><b>{{ $prison->code }}</b>-{{ $prison->name }} | <span class="text-danger text-uppercase">{{$prison->type}}</span></h4><hr>
                            <p class="mb-0">{{ $prison->description }}</p>
                        </div>
                        <div class="col-lg-6 text-right" style="text-align: right">
                            <h4><b>Localisation:</b> {{ $prison->quartier->name }}</h4><hr>
                            <p class="mb-0">{{ $prison->user->name }}</p>
                        </div>
                    </div>
                </div>
                <div class="content mt-2">
                    <!-- Onglets -->
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <a class="nav-link active" id="home-tab" data-bs-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Tableau de bord</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="profile-tab" data-bs-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Arrestations</a>
                        </li>
                        
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="contact-tab" data-bs-toggle="tab" href="#contact" role="tab" aria-controls="contact" aria-selected="false">Interventions</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="logistique-tab" data-bs-toggle="tab" href="#logistique" role="tab" aria-controls="contact" aria-selected="false">Logistique</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="user-tab" data-bs-toggle="tab" href="#user" role="tab" aria-controls="contact" aria-selected="false">Utilisateur</a>
                        </li>
                        
                    </ul>
                    
                    <!-- Contenu des onglets -->
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                            <div class="card shadow p-2">
                                <p class="text-center">Bienvenue dans la section tableau de bord de la prison <b>{{ $prison->name }}</b> !</p>
                                <p class="text-center">Ici vous pouvez voir les statistiques de votre prison.</p>
                                <p class="text-center">Vous pouvez aussi voir les crimes et les arrestations de votre prison.</p>
                                <p class="text-center">Vous pouvez aussi voir les interventions de votre prison.</p>
                            </div>
                            <div class="card shadow p-2 mt-2">
                                <div class="row mb-4">
                                    <div class="col-md-3">
                                        <div class="card text-white bg-primary shadow">
                                            <div class="card-body">
                                                <h5 class="card-title">Arrestations</h5>
                                                <p class="card-text fs-3">{{ $arrestationCount }}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card text-white bg-success shadow">
                                            <div class="card-body">
                                                <h5 class="card-title">Matériels</h5>
                                                <p class="card-text fs-3">{{ $materielCount }}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card text-white bg-warning shadow">
                                            <div class="card-body">
                                                <h5 class="card-title">Interventions</h5>
                                                <p class="card-text fs-3">{{ $interventionCount }}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card text-white bg-info shadow">
                                            <div class="card-body">
                                                <h5 class="card-title">Agents affectés</h5>
                                                <p class="card-text fs-3">{{ $userCount }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Arrestations --}}
                                <h5 class="mt-4">Arrestations récentes</h5>
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Nom</th>
                                            <th>Date</th>
                                            <th>Motif</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($recentArrestations as $arrestation)
                                            <tr>
                                                <td>{{ $arrestation->nom ?? '-' }}</td>
                                                <td>{{ $arrestation->created_at->format('d/m/Y') }}</td>
                                                <td>{{ $arrestation->motif ?? '-' }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>

                                {{-- Matériels --}}
                                <h5 class="mt-4">Matériels enregistrés</h5>
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Nom</th>
                                            <th>Quantité</th>
                                            <th>Ajouté le</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($recentMateriels as $materiel)
                                            <tr>
                                                <td>{{ $materiel->type ?? '-' }}{{ $materiel->description ?? '-' }}</td>
                                                <td>{{ $materiel->quantite ?? '1' }}</td>
                                                <td>{{ $materiel->created_at->format('d/m/Y') }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>

                                {{-- Interventions --}}
                                <h5 class="mt-4">Interventions récentes</h5>
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Type</th>
                                            <th>Effectué par</th>
                                            <th>Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($recentInterventions as $intervention)
                                            <tr>
                                                <td>{{ $intervention->type ?? '-' }}</td>
                                                <td>{{ $intervention->user->name ?? 'N/A' }}</td>
                                                <td>{{ $intervention->created_at->format('d/m/Y') }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="card shadow p-2 mt-2">
                                

                                <div class="row mt-5">
                                    <div class="col-md-6">
                                        <h5>📉 Arrestations mensuelles</h5>
                                        <canvas id="chartArrestations"></canvas>
                                    </div>
                                    <div class="col-md-6">
                                        <h5>📦 Répartition du matériel</h5>
                                        <canvas id="chartMateriel"></canvas>
                                    </div>
                                </div>

                                <div class="row mt-4">
                                    <div class="col-12">
                                        <h5>🗺️ Localisation de la prison</h5>
                                        <div id="map" style="height: 400px;"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                            <div class="card shadow p-2">
                                <table class="table table-bordered table-striped table-hover" id="myTable">
                                    <thead>
                                        <tr>
                                            <th>Matricule</th>
                                            <th>Prisonier</th>
                                            <th>Date d'Arrestation</th>
                                            <th>Prison</th>
                                            <th>Autorité Responsable</th>
                                            <th>Statut</th>
                                            <th>Crimes Associés</th>
                                            @if(Auth::user()->role === 'admin')
                                                <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($prison->arrestations as $arrestation)
                                            <tr>
                                                <td>{{ $arrestation->prisonier->matricule }}</td>
                                                <td>{{ $arrestation->prisonier->nom }}{{ $arrestation->prisonier->prenom }}</td>
                                                <td>{{ $arrestation->date_arrestation }}</td>
                                                <td>{{ $arrestation->prison->name }}</td>
                                                <td>{{ $arrestation->user->name }}</td>
                                                <td>{{ $arrestation->statut }}</td>
                                                <td>
                                                    <ul class="mb-0">
                                                        @foreach($arrestation->crimes as $crime)
                                                            <li>{{ $crime->code }} - {{ $crime->libelle }}</li>
                                                        @endforeach
                                                    </ul>
                                                </td>

                                                @if(Auth::user()->role === 'admin')
                                                    <td>
                                                        <a href="{{ route('prisonier.arrestation.edit', $arrestation->id) }}">✏️</a>
                                                        <button onclick="confirmDelete({{ $crime->id }})">🗑️</button>
                                                        <a href="{{ route('crimes.detail', $crime->id) }}" >👁️</a>
                                                    </td>
                                                @endif
                                                
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                            <table class="table table-bordered table-striped" id="myTable1">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Type d'operation</th>
                                        <th>Description</th>
                                        <th>Responsable</th>
                                        <th>Date d'operation</th>
                                        <th>Prison ID</th>
                                        @if(Auth::user()->role === 'admin')
                                            <th>Action</th>
                                        @endif
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($prison->operations as $operation)
                                        <tr>
                                            <td>{{ $operation->id }}</td>
                                            <td>{{ $operation->type }}</td>
                                            <td>{{ $operation->description }}</td>
                                            <td>{{ $operation->responsable }}</td>
                                            <td>{{ $operation->date_operation }}</td>
                                            <td>{{ $operation->prison ? $operation->prison->name : 'Non attribuée' }}</td>
                                            @if(Auth::user()->role === 'admin')
                                            <td>
                                                    <a href="{{ route('operations.edit', $operation->id) }}">✏️</a>
                                            </td>
                                            @endif
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="tab-pane fade" id="logistique" role="tabpanel" aria-labelledby="contact-tab">
                            <table class="table table-bordered table-striped" id="myTable2">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Type de Matériel</th>
                                        <th>Description</th>
                                        <th>Quantité</th>
                                        <th>Date d'Attribution</th>
                                        <th>Prison Associée</th>
                                        @if(Auth::user()->role === 'admin')
                                            <th>Action</th>
                                        @endif
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($prison->materielPrisons as $materiel)
                                        <tr>
                                            <td>{{ $materiel->id }}</td>
                                            <td>{{ $materiel->type }}</td>
                                            <td>{{ $materiel->description }}</td>
                                            <td>{{ $materiel->quantite }}</td>
                                            <td>{{ $materiel->date_attribution }}</td>
                                            <td>{{ $materiel->prison ? $materiel->prison->name : 'Non attribuée' }}</td>
                                            @if(Auth::user()->role === 'admin')
                                            <td>
                                                    <a href="{{ route('materiels.edit', $materiel->id) }}">✏️</a>
                                            </td>
                                            @endif
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="tab-pane fade" id="user" role="tabpanel" aria-labelledby="contact-tab">
                            <div class="card shadow p-4">
                                <table class="table table-hover table-bordered" id="myTable3">
                                    <thead>
                                        <tr>
                                            <th>Nom</th>
                                            <th>Email</th>
                                            <th>Téléphone</th>
                                            <th>Rôle</th>
                                            <th>Prison</th>
                                            <th>Quartier</th>
                                            <th>Arrondissement</th>
                                            <th>Zone</th>
                                            <th>Ville</th>
                                            @if(Auth::user()->role === 'admin')
                                                <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($prison->users as $user)
                                            <tr>
                                                <td>{{ $user->name }}</td>
                                                <td>{{ $user->email }}</td>
                                                <td>{{ $user->phone_number }}</td>
                                                <td>{{ $user->role }}</td>
                                                <td>{{ $user->prison->name ?? 'Aucune' }}</td>
                                                <td>{{ $user->prison->quartier->name ?? '—' }}</td>
                                                <td>{{ $user->prison->quartier->arrondissement->name ?? '—' }}</td>
                                                <td>{{ $user->prison->quartier->arrondissement->zone->name ?? '—' }}</td>
                                                <td>{{ $user->prison->quartier->arrondissement->zone->ville->name ?? '—' }}</td>
                                                @if(Auth::user()->role === 'admin')
                                                    <td>
                                                        <a href="{{ route('users.edit', $user->id) }}">✏️</a>

                                                        @if(Auth::id() !== $user->id)
                                                            <button onclick="confirmDelete({{ $user->id }})">🗑️</button>

                                                            <form id="delete-form-{{ $user->id }}" method="POST" action="{{ route('users.destroy', $user->id) }}" style="display: none;">
                                                                @csrf
                                                                @method('DELETE')
                                                            </form>
                                                        @endif
                                                    </td>
                                                @endif
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    </div>


            </div>
                
        </div>
    </div>
</x-app-layout>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
    // Chart Arrestations
    new Chart(document.getElementById('chartArrestations'), {
        type: 'line',
        data: {
        labels: {!! json_encode($arrestationsMonthly->pluck('mois')) !!},
        datasets: [{
            label: 'Arrestations',
            data: {!! json_encode($arrestationsMonthly->pluck('total')) !!},
            borderColor: 'rgb(75, 192, 192)',
            tension: 0.1
        }]
        }
    });

    // Chart Matériel
    new Chart(document.getElementById('chartMateriel'), {
        type: 'bar',
        data: {
        labels: {!! json_encode($materielParType->pluck('type')) !!},
        datasets: [{
            label: 'Quantité',
            data: {!! json_encode($materielParType->pluck('total')) !!},
            backgroundColor: 'rgba(153, 102, 255, 0.6)'
        }]
        },
        options: {
        scales: { y: { beginAtZero: true } }
        }
    });

    // Leaflet map
    var map = L.map('map').setView([{{ $prison->latitude }}, {{ $prison->longitude }}], 12);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy; OpenStreetMap',
        maxZoom: 18
    }).addTo(map);
    L.marker([{{ $prison->latitude }}, {{ $prison->longitude }}])
    .addTo(map)
    .bindPopup('<b>{{ addslashes($prison->name) }}</b><br>{{ addslashes($prison->location) }}');
    });
    </script>