<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2.5rem !important;
    }
    ul#myTab {
        background: #333 !important;
        height: 50px !important;
    }
    a.nav-link {
        background: #333333 !important;

    }
    .nav-tabs .nav-link{
        color: #fff !important;
    }
    a.nav-link.active {
        background: #f3f4f6 !important;
        border-radius: 0 !important;
        color: #000 !important;
    }
</style>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>

<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('prisoniers.navigation')
        </x-slot>

        <div class="container">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3">
                <!-- resources/views/admin/users/create.blade.php -->
                 <div class="card shadow p-4">
                    <div class="row">
                        <div class="col-lg-6">
                            <h4><b>{{ $prisonier->matricule }}</b>-{{ $prisonier->nom }} {{ $prisonier->prenom }} | <span class="text-danger text-uppercase">{{$prisonier->sexe}}</span></h4><hr>
                            <p class="mb-0">{{ $prisonier->statut_matrimonial }}</p>
                            <img src="{{ Storage::url($prisonier->photo) }}" style="height: 100px;" alt="">
                        </div>
                        <div class="col-lg-6 text-right" style="text-align: right">
                            <h4><b>Date de naiss:</b> {{ $prisonier->date_naissance }} |<b>Nationalité:</b> {{ $prisonier->nationalite }}</h4><hr>
                            
                        </div>
                    </div>
                </div>
                <div class="content mt-2">
                    <!-- Onglets -->
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <a class="nav-link active" id="home-tab" data-bs-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Tableau de bord</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="profile-tab" data-bs-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Arrestations</a>
                        </li>
                        
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="contact-tab" data-bs-toggle="tab" href="#contact" role="tab" aria-controls="contact" aria-selected="false">Crimes</a>
                        </li>
                        
                        
                    </ul>
                    
                    <!-- Contenu des onglets -->
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                            <div class="card shadow p-4">
                                <div class="row mb-4">
                                    <div class="col-md-3 mb-3">
                                        <div class="card text-white bg-primary h-100">
                                            <div class="card-body">
                                                <h5 class="card-title">🔐 Arrestations</h5>
                                                <p class="card-text display-6">{{ $arrestationCount }}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <div class="card text-white bg-danger h-100">
                                            <div class="card-body">
                                                <h5 class="card-title">⚖️ Crimes</h5>
                                                <p class="card-text display-6">{{ $crimeCount }}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <div class="card text-dark bg-warning h-100">
                                            <div class="card-body">
                                                <h5 class="card-title">⏳ Durée détenu</h5>
                                                <p class="card-text display-6">{{ $dureeDetention }} <small>jours</small></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <div class="card text-white bg-info h-100">
                                            <div class="card-body">
                                                <h5 class="card-title">🟢 Statut</h5>
                                                <p class="card-text display-6">{{ ucfirst($prisonier->statut) }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                {{-- Graphiques --}}
                                <div class="row">
                                    <div class="col-md-6">
                                        <h5>📉 Arrestations par mois</h5>
                                        <canvas id="chartArrestations"></canvas>
                                    </div>
                                    <div class="col-md-6">
                                        <h5>⚖️ Répartition par rôle</h5>
                                        <canvas id="chartRoles"></canvas>
                                    </div>
                                </div>

                                {{-- Tableaux --}}
                                <div class="mt-4">
                                    <h5>Crimes enregistrés</h5>
                                    <table class="table table-striped">
                                        <thead><tr><th>Crime</th><th>Rôle</th><th>Date</th><th>Condamnation</th></tr></thead>
                                        <tbody>
                                            @foreach($crimes as $crime)
                                            <tr>
                                                <td>{{ $crime->nom }}</td>
                                                <td>{{ $crime->pivot->rôle }}</td>
                                                <td>{{ $crime->pivot->date_implication }}</td>
                                                <td>{{ $crime->pivot->condamnation }}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>

                                    <h5>Arrestations</h5>
                                    <table class="table table-striped">
                                        <thead><tr><th>Date</th><th>Motif</th><th>Prison</th></tr></thead>
                                        <tbody>
                                            @foreach($arrestations as $arr)
                                            <tr>
                                                <td>{{ $arr->created_at->format('d/m/Y') }}</td>
                                                <td>{{ $arr->motif ?? '-' }}</td>
                                                <td>{{ $arr->prison->name ?? 'N/A' }}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                            <div class="card shadow p-4">
                                <table class="table table-bordered table-striped table-hover" id="myTable">
                                    <thead>
                                        <tr>
                                            <th>Matricule</th>
                                            <th>Prisonier</th>
                                            <th>Date d'Arrestation</th>
                                            <th>Prison</th>
                                            <th>Autorité Responsable</th>
                                            <th>Statut</th>
                                            <th>Crimes Associés</th>
                                            @if(Auth::user()->role === 'admin')
                                                <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($prisonier->arrestations as $arrestation)
                                            <tr>
                                                <td>{{ $arrestation->prisonier->matricule }}</td>
                                                <td>{{ $arrestation->prisonier->nom }}{{ $arrestation->prisonier->prenom }}</td>
                                                <td>{{ $arrestation->date_arrestation }}</td>
                                                <td>{{ $arrestation->prison->name }}</td>
                                                <td>{{ $arrestation->user->name }}</td>
                                                <td>{{ $arrestation->statut }}</td>
                                                <td>
                                                    <ul class="mb-0">
                                                        @foreach($arrestation->crimes as $crime)
                                                            <li>{{ $crime->code }} - {{ $crime->libelle }}</li>
                                                        @endforeach
                                                    </ul>
                                                </td>

                                                @if(Auth::user()->role === 'admin')
                                                    <td>
                                                        <a href="{{ route('prisonier.arrestation.edit', $arrestation->id) }}">✏️</a>
                                                        <button onclick="confirmDelete({{ $crime->id }})">🗑️</button>
                                                        <a href="{{ route('crimes.detail', $crime->id) }}" >👁️</a>
                                                    </td>
                                                @endif
                                                
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                            <div class="card shadow p-4">
                                <table class="table table-bordered table-striped table-hover" id="myTable1">
                                    <thead class="table-dark">
                                        <tr>
                                            <th>ID</th>
                                            <th>Code</th>
                                            <th>Libellé</th>
                                            <th>Description</th>
                                            <th>Niveau Gravité</th>
                                            <th>Loi Associée</th>
                                            <th>Date du Crime</th>
                                            <th>Lieu du Crime</th>
                                            <th>Créé le</th>
                                            <th>Modifié le</th>
                                            @if(Auth::user()->role === 'admin')
                                                <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse ($prisonier->crimes as $crime)
                                            <tr>
                                                <td>{{ $crime->id }}</td>
                                                <td>{{ $crime->code }}</td>
                                                <td>{{ $crime->libelle }}</td>
                                                <td>{{ $crime->description }}</td>
                                                <td>{{ $crime->niveau_gravite }}</td>
                                                <td>{{ $crime->loi_associee }}</td>
                                                <td>{{ $crime->date_crime }}</td>
                                                <td>{{ $crime->lieu_crime }}</td>
                                                <td>{{ $crime->created_at->format('d/m/Y H:i') }}</td>
                                                <td>{{ $crime->updated_at->format('d/m/Y H:i') }}</td>
                                                @if(Auth::user()->role === 'admin')
                                                    <td>
                                                        <a href="{{ route('crimes.edit', $crime->id) }}">✏️</a>
                                                        <button onclick="confirmDelete({{ $crime->id }})">🗑️</button>
                                                        <a href="{{ route('crimes.detail', $crime->id) }}" >👁️</a>
                                                    </td>
                                                @endif
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="10" class="text-center">Aucun crime enregistré.</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="logistique" role="tabpanel" aria-labelledby="contact-tab">
                            
                        </div>
                        <div class="tab-pane fade" id="user" role="tabpanel" aria-labelledby="contact-tab">
                            <div class="card shadow p-4">
                                
                            </div>
                        </div>
                    </div>
                    </div>


            </div>
                
        </div>
    </div>
</x-app-layout>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    new Chart(document.getElementById('chartArrestations'), {
        type: 'line',
        data: {
            labels: {!! json_encode($arrestationsParMois->pluck('mois')) !!},
            datasets: [{
                label: 'Arrestations',
                data: {!! json_encode($arrestationsParMois->pluck('total')) !!},
                borderColor: 'rgb(75, 192, 192)',
                tension: 0.3
            }]
        }
    });

    new Chart(document.getElementById('chartRoles'), {
        type: 'pie',
        data: {
            labels: {!! json_encode($roles->pluck('rôle')) !!},
            datasets: [{
                data: {!! json_encode($roles->pluck('total')) !!},
                backgroundColor: ['#dc3545','#ffc107','#0d6efd']
            }]
        }
    });
});
</script>