<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2.5rem !important;
    }
</style>
<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('prisoniers.navigation')
        </x-slot>


        <a href="{{ route('prisoniers.index') }}" class="btn btn-danger mb-1">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">Nouveau crime</h4>
        <hr>


        <div class="content">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3">
                <!-- resources/views/admin/users/create.blade.php -->
                 <div class="card shadow p-4">
                    <form action="{{ route('crimes.update', $crime->id) }}" method="POST">
                            @csrf
                            @method('PUT') <!-- Cette ligne indique que nous effectuons une mise à jour (PUT) -->

                            <div class="row">
                                <!-- Code (readonly) -->
                                <div class="col-md-4 mb-1">
                                    <label for="code" class="form-label">Code</label>
                                    <input type="text" class="form-control @error('code') is-invalid @enderror" readonly name="code" value="{{ $crime->code }}">
                                    @error('code') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>

                                <!-- Libellé -->
                                <div class="col-md-4 mb-1">
                                    <label for="libelle" class="form-label">Libellé</label>
                                    <input type="text" class="form-control @error('libelle') is-invalid @enderror" name="libelle" value="{{ old('libelle', $crime->libelle) }}">
                                    @error('libelle') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>

                                <!-- Niveau de gravité -->
                                <div class="col-md-4 mb-1">
                                    <label for="niveau_gravite" class="form-label">Niveau de gravité</label>
                                    <select class="form-select @error('niveau_gravite') is-invalid @enderror" name="niveau_gravite">
                                        <option value="">-- Sélectionner --</option>
                                        <option value="Faible" {{ old('niveau_gravite', $crime->niveau_gravite) == 'Faible' ? 'selected' : '' }}>Faible</option>
                                        <option value="Moyenne" {{ old('niveau_gravite', $crime->niveau_gravite) == 'Moyenne' ? 'selected' : '' }}>Moyenne</option>
                                        <option value="Élevée" {{ old('niveau_gravite', $crime->niveau_gravite) == 'Élevée' ? 'selected' : '' }}>Élevée</option>
                                    </select>
                                    @error('niveau_gravite') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>

                            <div class="row">
                                <!-- Loi associée -->
                                <div class="col-md-4 mb-1">
                                    <label for="loi_associee" class="form-label">Loi associée</label>
                                    <input type="text" class="form-control" name="loi_associee" value="{{ old('loi_associee', $crime->loi_associee) }}">
                                </div>

                                <!-- Date du crime -->
                                <div class="col-md-4 mb-1">
                                    <label for="date_crime" class="form-label">Date du crime</label>
                                    <input type="date" class="form-control" name="date_crime" value="{{ old('date_crime', $crime->date_crime) }}">
                                </div>

                                <!-- Quartier -->
                                <div class="col-md-4 mb-1">
                                    <label for="quartier_id" class="form-label">Quartier</label>
                                    <select name="quartier_id" class="form-control" required>
                                        <option value="">-- Sélectionner --</option>
                                        @foreach($quartiers as $quartier)
                                            <option value="{{ $quartier->id }}" {{ old('quartier_id', $crime->quartier_id) == $quartier->id ? 'selected' : '' }}>
                                                {{ $quartier->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <!-- Lieu du crime -->
                                <div class="col-md-4 mb-1">
                                    <label for="lieu_crime" class="form-label">Lieu du crime</label>
                                    <input type="text" class="form-control" name="lieu_crime" value="{{ old('lieu_crime', $crime->lieu_crime) }}">
                                </div>
                            </div>

                            <div class="row">
                                <!-- Description -->
                                <div class="col-md-12 mb-1">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea class="form-control" name="description" rows="8">{{ old('description', $crime->description) }}</textarea>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 text-end">
                                    <button type="submit" class="btn btn-danger">Mettre à jour</button>
                                    <a href="{{ route('crimes.index') }}" class="btn btn-secondary">Annuler</a>
                                </div>
                            </div>
                        </form>


                </div>

            </div>
                
        </div>
    </div>
</x-app-layout>

