<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2.5rem !important;
    }
</style>
<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('prisoniers.navigation')
        </x-slot>


        <a href="{{ route('prisoniers.index') }}" class="btn btn-danger mb-1">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">Nouveau commissariat / Poste</h4>
        <hr>


        <div class="content">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3">
                <!-- resources/views/admin/users/create.blade.php -->
                 <div class="card shadow p-4">
                    <form action="{{ route('prisoniers.arrestation.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="row">
                            <!-- Nom -->
                            <div class="col-md-4 mb-1">
                                <label for="nom" class="form-label">Nom</label>
                                <input type="text" class="form-control" name="nom" id="nom" required>
                            </div>

                            <!-- Prénom -->
                            <div class="col-md-4 mb-1">
                                <label for="prenom" class="form-label">Prénom</label>
                                <input type="text" class="form-control" name="prenom" id="prenom" required>
                            </div>

                            <!-- Matricule -->
                            <div class="col-md-4 mb-1">
                                <label for="matricule" class="form-label">Matricule</label>
                                <input type="text" class="form-control" readonly value="{{$matricule}}" name="matricule" id="matricule" required>
                            </div>

                            <!-- Sexe -->
                            <div class="col-md-4 mb-1">
                                <label for="sexe" class="form-label">Sexe</label>
                                <select class="form-select" name="sexe" id="sexe" required>
                                    <option value="">-- Sélectionner --</option>
                                    <option value="Homme">Homme</option>
                                    <option value="Femme">Femme</option>
                                </select>
                            </div>

                            <!-- Date de naissance -->
                            <div class="col-md-4 mb-1">
                                <label for="date_naissance" class="form-label">Date de naissance</label>
                                <input type="date" class="form-control" name="date_naissance" id="date_naissance">
                            </div>

                            <!-- Lieu de naissance -->
                            <div class="col-md-4 mb-1">
                                <label for="lieu_naissance" class="form-label">Lieu de naissance</label>
                                <input type="text" class="form-control" name="lieu_naissance" id="lieu_naissance">
                            </div>

                            <!-- Nationalité -->
                            <div class="col-md-4 mb-1">
                                <label for="nationalite" class="form-label">Nationalité</label>
                                <input type="text" class="form-control" name="nationalite" id="nationalite">
                            </div>

                            <!-- Statut matrimonial -->
                            <div class="col-md-4 mb-1">
                                <label for="statut_matrimonial" class="form-label">Statut matrimonial</label>
                                <select class="form-select" name="statut_matrimonial" id="statut_matrimonial">
                                    <option value="">-- Sélectionner --</option>
                                    <option value="Célibataire">Célibataire</option>
                                    <option value="Marié(e)">Marié(e)</option>
                                    <option value="Divorcé(e)">Divorcé(e)</option>
                                    <option value="Veuf(ve)">Veuf(ve)</option>
                                </select>
                            </div>

                            <!-- Photo -->
                            <div class="col-md-4 mb-1">
                                <label for="photo" class="form-label">Photo</label>
                                <input type="file" class="form-control" name="photo" id="photo" accept="image/*">
                            </div>

                            <!-- Statut -->
                            <div class="col-md-4 mb-1">
                                <label for="statut" class="form-label">Statut</label>
                                <select class="form-select" name="statut" id="statut">
                                    <option value="Arrêté" selected>Arrêté</option>
                                    <option value="Libéré">Libéré</option>
                                    <option value="Transféré">Transféré</option>
                                </select>
                            </div>

                        </div>

                        <!-- Bouton de soumission -->
                        <div class="mt-4">
                            <button type="submit" class="btn btn-danger">Enregistrer</button>
                            <a href="{{ route('prisoniers.index') }}" class="btn btn-secondary">Annuler</a>
                        </div>

                    </form>

                </div>

            </div>
                
        </div>
    </div>
</x-app-layout>

