<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('prisons.navigation')
        </x-slot>

        <a href="{{ route('prisons.index') }}" class="btn btn-primary mb-3">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">{{$title}}</h4>
        <hr>
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card shadow bg-primary text-white">
                    <div class="card-body">Total Prisons: <strong>{{ $totalPrisons }}</strong></div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card shadow bg-info text-white">
                    <div class="card-body">Total CC: <strong>{{ $prisonsByType['CC'] ?? 0 }}</strong></div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card shadow bg-warning text-dark">
                    <div class="card-body">Total CPA: <strong>{{ $prisonsByType['CPA'] ?? 0 }}</strong></div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card shadow bg-success text-white">
                    <div class="card-body">Total CPQ: <strong>{{ $prisonsByType['CPQ'] ?? 0 }}</strong></div>
                </div>
            </div>
            <div class="col-md-3 mt-3">
                <div class="card shadow bg-secondary text-white">
                    <div class="card-body">Total PA: <strong>{{ $prisonsByType['PA'] ?? 0 }}</strong></div>
                </div>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">Quartier avec le plus de prisons</div>
                    <div class="card-body">
                        {{ $topQuartier->name ?? 'N/A' }} ({{ $topQuartier->total ?? 0 }})
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">Plus grande prison (par capacité)</div>
                    <div class="card-body">
                        {{ $largestPrison->name ?? 'N/A' }} (Capacité: {{ $largestPrison->capacity ?? 0 }})
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-md-6">
                <div class="card shadow bg-success text-white">
                    <div class="card-body">Prisons Actives: <strong>{{ $prisonsByStatus[1] ?? 0 }}</strong></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card shadow bg-danger text-white">
                    <div class="card-body">Prisons Inactives: <strong>{{ $prisonsByStatus[0] ?? 0 }}</strong></div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>

