<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('materiel_prison.navigation')
        </x-slot>

        <a href="{{ route('materiels.create') }}" class="btn btn-danger shadow" >+ Nouveau</a>
        <h4 style="float:right;width:fit-content;color:#333">{{$title}}</h4>
        <hr>
        <table class="table table-bordered table-striped" id="myTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Type de Matériel</th>
                    <th>Description</th>
                    <th>Quantité</th>
                    <th>Date d'Attribution</th>
                    <th>Prison Associée</th>
                     @if(Auth::user()->role === 'admin')
                        <th>Action</th>
                    @endif
                </tr>
            </thead>
            <tbody>
                @foreach($materiels as $materiel)
                    <tr>
                        <td>{{ $materiel->id }}</td>
                        <td>{{ $materiel->type }}</td>
                        <td>{{ $materiel->description }}</td>
                        <td>{{ $materiel->quantite }}</td>
                        <td>{{ $materiel->date_attribution }}</td>
                        <td>{{ $materiel->prison ? $materiel->prison->name : 'Non attribuée' }}</td>
                         @if(Auth::user()->role === 'admin')
                           <td>
                                <a href="{{ route('materiels.edit', $materiel->id) }}">✏️</a>
                           </td>
                        @endif
                    </tr>
                @endforeach
            </tbody>
        </table>

    </div>

</x-app-layout>

    <!-- Modal -->
<div class="modal fade" id="createPrisonModal" tabindex="1" aria-labelledby="createPrisonModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-md"> <!-- Large modal -->
    <div class="modal-header" style="
                background: #000;color: #fff !important;
      ">
      <h5 class="modal-title" id="createPrisonModalLabel" >Veuillez choisir le type</h5>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="background: #fff"></button>
    </div>
    <div class="modal-content">
      <a href="{{ route('prisons.create', ['type' => 'cc']) }}" class="btn btn-default form-control shadow">Commissariat Central (CC)</a>
      <a href="{{ route('prisons.create', ['type' => 'cpa']) }}" class="btn btn-default form-control shadow">Commissariat de Police d'Arrondissement (CPA)</a>
      <a href="{{ route('prisons.create', ['type' => 'cpq']) }}" class="btn btn-default form-control shadow">Commissariat de Police de quartier (CPQ)</a>
      <a href="{{ route('prisons.create', ['type' => 'pa']) }}" class="btn btn-default form-control shadow">Poste avancé</a>
    </div>
  </div>
</div>

<script>
    function confirmDelete(userId) {
        Swal.fire({
            title: 'Êtes-vous sûr ?',
            text: "Cette action est irréversible.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Oui, supprimer',
            cancelButtonText: 'Annuler'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('delete-form-' + userId).submit();
            }
        });
    }
</script>

<script>
    document.getElementById('check-all').addEventListener('change', function () {
        const checkboxes = document.querySelectorAll('.checkbox');
        checkboxes.forEach(cb => cb.checked = this.checked);
    });

    document.getElementById('bulk-delete-btn').addEventListener('click', function () {
        const form = document.getElementById('bulk-delete-form');
        const selected = form.querySelectorAll('.checkbox:checked');

        if (selected.length === 0) {
            Swal.fire('Aucun élément sélectionné', 'Veuillez sélectionner au moins un utilisateur.', 'info');
            return;
        }

        Swal.fire({
            title: 'Confirmer la suppression ?',
            text: "Les utilisateurs sélectionnés seront supprimés.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Oui, supprimer',
            cancelButtonText: 'Annuler',
            confirmButtonColor: '#d33'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    });
</script>


<!-- Bootstrap JS avec Popper -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

