<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2.5rem !important;
    }
    
</style>
<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
           @include('materiel_prison.navigation')
        </x-slot>


        <a href="{{ route('prisons.index') }}" class="btn btn-danger mb-3">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">Edition commissariat / Poste</h4>
        <hr>


        <div class="container">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3">
                <!-- resources/views/admin/users/create.blade.php -->
                 <div class="card shadow p-4">
                    <form action="{{ route('materiels.update',$materiel->id) }}" method="POST">
                    @csrf
                     @method('PUT')
                    <div class="card shadow p-4 mb-2">
                        <div class="row">
                            <div class="col-lg-4">
                               <input type="hidden" name="id" value="{{$materiel->id}}">
                                <div class="form-group">
                                    <label for="type">Type de Matériel</label>
                                    <select name="type" id="type" class="form-control" required>
                                        <option value="">-- Choisir un type de matériel --</option>
                                        <option value="Arme" @if($materiel->type=='Arme') selected @endif >Arme</option>
                                        <option value="Véhicule" @if($materiel->type=='Véhicule') selected @endif>Véhicule</option>
                                        <option value="Matraque" @if($materiel->type=='Matraque') selected @endif>Matraque</option>
                                        <option value="Vêtements"   @if($materiel->type=='Vêtements') selected @endif>Vêtements</option>
                                        <!-- Ajoute d'autres types si nécessaire -->
                                    </select>
                                </div>
                                
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label for="description">Description</label>
                                    <input type="text" name="description" id="description" value="{{$materiel->description}}" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="quantite">Quantité</label>
                                    <input type="number" name="quantite" id="quantite" value="{{$materiel->quantite}}" class="form-control" required>
                                </div>
                                
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="date_attribution">Date d'Attribution</label>
                                    <input type="date" name="date_attribution" id="date_attribution" value="{{$materiel->date_attribution}}" class="form-control" required>
                                </div>
                                
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="prison_id">Prison</label>
                                    <select name="prison_id" id="prison_id" class="form-control" required>
                                        <option value="">-- Choisir une prison --</option>
                                        @foreach($prisons as $prison)
                                            <option value="{{ $prison->id }}" @if($materiel->prison->id==$prison->id) Selected @endif>{{ $prison->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <button class="btn btn-success" type="submit">Mettre à jours</button>
                            </div>
                        </div>
                    </div>
                </form>

                </div>

            </div>
                
        </div>
    </div>
</x-app-layout>

