<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2.5rem !important;
    }
    ul#myTab {
        background: #333 !important;
        height: 50px !important;
    }
    a.nav-link {
        background: #333333 !important;
    }
    a.nav-link.active {
        background: #f3f4f6 !important;
        border-radius: 0 !important;
    }
</style>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">

<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('prisoniers.navigation')
        </x-slot>


        <a href="{{ route('prisons.index') }}" class="btn btn-danger mb-3">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">Détail crime</h4>
        <hr>


        <div class="container">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3">
                <!-- resources/views/admin/users/create.blade.php -->
                 <div class="card shadow p-4">
                    <div class="row">
                        <div class="col-lg-6">
                            <h4><b>{{ $crime->code }}</b>-{{ $crime->libelle }} | <span class="text-danger">{{ $crime->niveau_gravite }}</span></h4><hr>
                            <p class="mb-0">{{ $crime->description }}</p>
                        </div>
                        <div class="col-lg-6 text-right" style="text-align: right">
                            <h4><b>Commis le:</b> {{ $crime->date_crime }} <b>à:</b> {{ $crime->quartier->name }}</h4><hr>
                            <p class="mb-0">{{ $crime->lieu_crime }}</p>
                        </div>
                    </div>
                </div>
                <div class="content mt-2">
                    <!-- Onglets -->
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                        <a class="nav-link active" id="home-tab" data-bs-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Les concernés</a>
                        </li>
                        <li class="nav-item" role="presentation">
                        <a class="nav-link" id="profile-tab" data-bs-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Photos du crime</a>
                        </li>
                        <li class="nav-item" role="presentation">
                        <a class="nav-link" id="contact-tab" data-bs-toggle="tab" href="#contact" role="tab" aria-controls="contact" aria-selected="false">Autre</a>
                        </li>
                    </ul>
                    
                    <!-- Contenu des onglets -->
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                            <div class="card shadow p-2">
                                <form action="{{ route('crimes.prisoniers.store') }}" method="POST">
                                    @csrf
                                    
                                    <input type="hidden" name="crime_id" value="{{ $crime->id }}">

                                    <div class="row">
                                        <!-- Prisonnier -->
                                        <div class="col-md-4 mb-1">
                                            <label for="prisonnier_id" class="form-label">Sélectionner un prisonnier</label>
                                            <select name="prisonnier_id" class="form-select @error('prisonnier_id') is-invalid @enderror" required>
                                                <option value="">-- Sélectionner --</option>
                                                @foreach($prisonniers as $prisonnier)
                                                    <option value="{{ $prisonnier->id }}" {{ old('prisonnier_id') == $prisonnier->id ? 'selected' : '' }}>
                                                        {{ $prisonnier->matricule }} - {{ $prisonnier->nom }} {{ $prisonnier->prenom }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            @error('prisonnier_id')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <!-- Rôle -->
                                        <div class="col-md-4 mb-1">
                                            <label for="rôle" class="form-label">Rôle dans le crime</label>
                                            <input type="text" class="form-control @error('rôle') is-invalid @enderror" name="rôle" value="{{ old('rôle') }}">
                                            @error('rôle')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <!-- Date d'implication -->
                                        <div class="col-md-4 mb-1">
                                            <label for="date_implication" class="form-label">Date d'implication</label>
                                            <input type="date" class="form-control @error('date_implication') is-invalid @enderror" name="date_implication" value="{{ old('date_implication') }}">
                                            @error('date_implication')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="row">
                                        <!-- Condamnation -->
                                        <div class="col-md-12 mb-1">
                                            <label for="condamnation" class="form-label">Condamnation</label>
                                            <textarea class="form-control @error('condamnation') is-invalid @enderror" name="condamnation" rows="5">{{ old('condamnation') }}</textarea>
                                            @error('condamnation')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <!-- Bouton de soumission -->
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-danger">Enregistrer</button>
                                        
                                    </div>
                                </form>
                                <table class="table table-bordered table-striped" id="myTable">
                                    <thead>
                                        <tr>
                                            <th>Nom</th>
                                            <th>Rôle</th>
                                            <th>Date d'implication</th>
                                            <th>Condamnation</th>
                                             @if(Auth::user()->role === 'admin')
                                                <th>
                                                    Action
                                                </th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                        @foreach($crime->prisonniers as $crimePrisonnier)
                                            <tr>
                                                <td>{{ $crimePrisonnier->nom }} {{ $crimePrisonnier->prenom }}</td>
                                                <td>{{ $crimePrisonnier->pivot->rôle }}</td>
                                                <td>{{ $crimePrisonnier->pivot->date_implication }}</td>
                                                <td>{{ $crimePrisonnier->pivot->condamnation }}</td>
                                                @if(Auth::user()->role === 'admin')
                                                    <td>
                                                        <button onclick="confirmDelete({{ $crimePrisonnier->pivot->id }})">🗑️</button>
                                                    </td>
                                                @endif
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                            <div class="card shadow p-2">
                                <form action="{{ route('crimes.photo.store') }}" method="POST" enctype="multipart/form-data">
                                    @csrf

                                    <!-- Autres champs pour le crime -->

                                    <div class="row">
                                        <!-- Photos -->
                                        <input type="hidden" name="id_crime" value="{{ $crime->id }}" id="">
                                        <div class="col-md-4 mb-1">
                                            <label for="photos" class="form-label">Ajouter des photos</label>
                                            <input type="file" class="form-control @error('photos') is-invalid @enderror" name="photos[]" id="photos" multiple>
                                            @error('photos') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                        </div>
                                    </div>

                                    <!-- Bouton de soumission -->
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-danger">Enregistrer</button>
                                    </div>
                                </form>
                                <hr>
                                <div class="row">
                                 @foreach($crime->photos as $photo)
                                    <div class="col-md-3" style="height:400px;overflow-y: hidden">
                                        <a href="{{ Storage::url($photo->photo_path) }}" target="_blank">
                                            <img src="{{ Storage::url($photo->photo_path) }}" alt="Photo du crime" class="img-thumbnail" style="width: 100%; height: auto;">
                                        </a>
                                    </div>
                                @endforeach
                                </div>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                        <!-- Accordéon dans l'onglet 3 -->
                        <div class="accordion" id="accordionContact">
                            <div class="accordion-item">
                            <h2 class="accordion-header" id="headingFour">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="true" aria-controls="collapseFour">
                                Section X
                                </button>
                            </h2>
                            <div id="collapseFour" class="accordion-collapse collapse show" aria-labelledby="headingFour" data-bs-parent="#accordionContact">
                                <div class="accordion-body">
                                Contenu de la section X
                                </div>
                            </div>
                            </div>
                        </div>
                        </div>
                    </div>
                    </div>


            </div>
                
        </div>
    </div>
</x-app-layout>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>