<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('finances.navigation') <!-- Crée ce fichier si nécessaire -->
        </x-slot>

         <a href="{{ route('finances.create') }}" class="btn btn-primary mb-3">+ Nouveau</a>
        <h4 style="float:right;width:fit-content;color:#333">Les statistiques</h4>
        <hr>

        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card text-white bg-danger shadow">
                    <div class="card-body">
                        <h5 class="card-title">Total finances non validées</h5>
                        <h3>{{ number_format($totalFinanceNonValide, 0, ',', ' ') }} F CFA</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-danger shadow">
                    <div class="card-body">
                        <h5 class="card-title">Total entrée non validées</h5>
                        <h3> {{ number_format($totalEntreeNonValide, 0, ',', ' ') }} F CFA</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-danger shadow">
                    <div class="card-body">
                        <h5 class="card-title">Total sorti non validées</h5>
                        <h3> {{ number_format($totalSortieNonValide, 0, ',', ' ') }} F CFA</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-danger shadow">
                    <div class="card-body">
                        <h5 class="card-title">Solde non validées</h5>
                        <h3> {{ number_format($soldeNonValide, 0, ',', ' ') }} F CFA</h3>
                    </div>
                </div>
            </div>
            
        </div>


        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card text-white bg-success shadow">
                    <div class="card-body">
                        <h5 class="card-title">Total finances validées</h5>
                        <h3> {{ number_format($totalFinanceValide, 0, ',', ' ') }} F CFA</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-success shadow">
                    <div class="card-body">
                        <h5 class="card-title">Entrées validées</h5>
                        <h3>{{ number_format($totalEntreeValide, 0, ',', ' ') }} F CFA</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-success ">
                    <div class="card-body">
                        <h5 class="card-title">Sorties validées</h5>
                        <h3>{{ number_format($totalSortieValide, 0, ',', ' ') }} F CFA</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-success ">
                    <div class="card-body">
                        <h5 class="card-title">Solde</h5>
                        <h3>{{ number_format($soldeValide, 0, ',', ' ') }} FCFA</h3>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-lg-6">
                 <div class="card text-white shadow">
                    <div class="card-body">
                        <h5 class="card-title">Par mois</h5>
                        <canvas id="graphMensuel" height="100"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card text-white shadow p-4">
                    <div class="card-body">
                        <h5 class="card-title">Par Source</h5>
                        <canvas id="graphSources" height="100"></canvas>
                    </div>
                </div>
            </div>
        </div>

       
        
    </div>
</x-app-layout>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const ctx1 = document.getElementById('graphMensuel').getContext('2d');
    new Chart(ctx1, {
        type: 'bar',
        data: {
            labels: {!! json_encode($mensuel->pluck('mois')) !!},
            datasets: [
                {
                    label: 'Entrées (€)',
                    data: {!! json_encode($mensuel->pluck('revenus')) !!},
                    backgroundColor: 'green'
                },
                {
                    label: 'Sorties (€)',
                    data: {!! json_encode($mensuel->pluck('depenses')) !!},
                    backgroundColor: 'red'
                }
            ]
        },
        options: {
            responsive: true,
            plugins: {
                title: {
                    display: true,
                    text: 'Évolution mensuelle des finances (validées)'
                }
            }
        }
    });

    const ctx2 = document.getElementById('graphSources').getContext('2d');
    new Chart(ctx2, {
        type: 'pie',
        data: {
            labels: {!! json_encode($parSource->pluck('source')) !!},
            datasets: [{
                label: 'Répartition par source',
                data: {!! json_encode($parSource->pluck('total')) !!},
                backgroundColor: ['#3366cc', '#dc3912', '#ff9900', '#109618', '#990099']
            }]
        },
        options: {
            plugins: {
                title: {
                    display: true,
                    text: 'Répartition des sources (validées)'
                }
            }
        }
    });
</script>



