<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('finances.navigation')
        </x-slot>

        <a href="{{ route('finances.create') }}" class="btn btn-primary mb-3">+ Nouveau</a>
        <h4 style="float:right;width:fit-content;color:#333">{{$title}}</h4>
        <hr>

        @if (session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            <hr>
        @endif

        <div style="
            display: flex;
            justify-content: space-between;
            align-items: center;
            align-content: center;
            margin-bottom:15px !important

        ">

            <form method="GET" action="{{ route('finances.index') }}" class="mb-4" style="
                margin: 0px !important;
            ">
                @csrf
                <input type="text" name="search" placeholder="Rechercher..." class="border px-4 py-2 w-1/3" value="{{ request('search') }}" style="width:270px">
                <button type="submit" class="bg-blue-500 text-white px-4 py-2">Rechercher</button>
            </form>

            <div class="caption">
                 
            </div>
        </div>

        <form id="bulk-delete-form" action="{{ route('finances.bulk-delete') }}" method="POST">
            @csrf
            @method('DELETE')
            <table class="table-auto w-full border-collapse border border-gray-300 shadow">
                <thead>
                    <tr class="bg-gray-200">
                        <th class="border px-4 py-2">#</th>
                        <th class="border text-center" width="30"><input type="checkbox" id="check-all"></th>
                        <th class="border px-4 py-2">Type</th>
                        <th class="border px-4 py-2">Montant (XAF)</th>
                        <th class="border px-4 py-2">Source</th>
                        <th class="border px-4 py-2">Réservation</th>
                        <th class="border px-4 py-2">Valide</th>
                        <th class="border px-4 py-2">Sens</th>
                        <th class="border px-4 py-2">Date</th>
                        <th class="border px-4 py-2">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @php $i = 1; @endphp
                    @foreach ($finances as $finance)
                        <tr>
                            <td class="border px-4 py-2">{{ $i++ }}</td>
                            <td class="border text-center" width="30">
                                <input type="checkbox" name="ids[]" value="{{ $finance->id }}" class="checkbox">
                            </td>
                            <td class="border px-4 py-2">{{ ucfirst(str_replace('_', ' ', $finance->type)) }}</td>
                            <td class="border px-4 py-2">{{ number_format($finance->montant, 0, ',', ' ') }}</td>
                            <td class="border px-4 py-2">{{ $finance->source ?? 'N/A' }}</td>
                            <td class="border px-4 py-2">
                                @if($finance->reservation)
                                    <a href="{{ route('reservations.show', $finance->reservation->id) }}" class="text-blue-500">
                                        {{ $finance->reservation->code }}
                                    </a>
                                @else
                                    <span class="text-gray-400">Non liée</span>
                                @endif
                            </td>
                            <td class="border px-4 py-2">
                                <span class="badge {{ $finance->valide ? 'bg-green-500' : 'bg-red-500' }} text-white px-2 py-1 rounded text-xs">
                                    {{ $finance->valide ? 'Oui' : 'Non' }}
                                </span>
                            </td>
                            <td class="border px-4 py-2">
                                <span class="badge {{ $finance->sens=='sortie' ? 'bg-red-500' : 'bg-green-500' }} text-white px-2 py-1 rounded text-xs">
                                    {{ $finance->sens }}
                                </span>
                            </td>
                            <td class="border px-4 py-2">
                                {{ \Carbon\Carbon::parse($finance->date_operation)->format('d/m/Y H:i') }}
                            </td>
                            <td class="border px-4 py-2">
                                @if ($finance->valide)
                                @else
                                <a href="{{ route('finances.edit', $finance->id) }}" class="text-info"><span class="fa fa-pencil-alt"></span> edit</a> |
                                @endif
                                <a style="cursor:pointer" class="text-danger delete-btn" ><span class="fa fa-file"></span> Voir.</a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <button id="bulk-delete-btn" type="button"></button>
        </form>
        <!-- Pagination -->
        <div class="mt-4">
            {{ $finances->links() }} <!-- Cela génère les liens de pagination -->
        </div>

    </div>
</x-app-layout>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const deleteButtons = document.querySelectorAll('.delete-btn');

        deleteButtons.forEach(button => {
            button.addEventListener('click', function () {
                const financeId = this.getAttribute('data-id');

                Swal.fire({
                    title: 'Êtes-vous sûr ?',
                    text: "Cette action est irréversible !",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Oui, supprimer',
                    cancelButtonText: 'Annuler'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById('delete-form-' + financeId).submit();
                    }
                });
            });
        });
    });
</script>

<script>
    document.getElementById('check-all').addEventListener('change', function () {
        const checkboxes = document.querySelectorAll('.checkbox');
        checkboxes.forEach(cb => cb.checked = this.checked);
    });

    document.getElementById('bulk-delete-btn').addEventListener('click', function () {
        const form = document.getElementById('bulk-delete-form');
        const selected = form.querySelectorAll('.checkbox:checked');

        if (selected.length === 0) {
            Swal.fire('Aucun élément sélectionné', 'Veuillez sélectionner au moins un utilisateur.', 'info');
            return;
        }

        Swal.fire({
            title: 'Confirmer la suppression ?',
            text: "Les utilisateurs sélectionnés seront supprimés.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Oui, supprimer',
            cancelButtonText: 'Annuler',
            confirmButtonColor: '#d33'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    });
</script>


