<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('cars.navigation')
        </x-slot>

        <a href="{{ route('cars.index') }}" class="btn btn-primary">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">Statistique</h4>
        <hr>
        
        <div class="container">
            
            <div class="p-3 shadow">
                <!-- WIDGETS -->
                <div class="row mb-4">
                    <div class="col-md-3">
                        <div class="card text-white bg-primary">
                            <div class="card-body">
                                <h5>Total véhicules</h5>
                                <h3>{{ $totalCars }}</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card text-white bg-success">
                            <div class="card-body">
                                <h5>Actifs</h5>
                                <h3>{{ $carsActifs }}</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card text-white bg-danger">
                            <div class="card-body">
                                <h5>Inactifs</h5>
                                <h3>{{ $carsInactifs }}</h3>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Graphiques et tableaux -->
                 <div class="row">
                    <div class="col-lg-4">
                         <div class="card mb-4 shadow" style="height: 388px;">
                            <div class="card-header">📆 Véhicules par mois</div>
                            <div class="card-body">
                                <canvas id="carsMois"></canvas>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                         <div class="card mb-4 shadow" style="height: 388px;">
                            <div class="card-header">⛽ Répartition par carburant</div>
                            <div class="card-body">
                                <canvas id="carburantChart"></canvas>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3">
                         <div class="card mb-4 shadow" style="height: 388px;">
                            <div class="card-header">🚘 Répartition par gamme</div>
                            <div class="card-body">
                                <canvas id="gammeChart"></canvas>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3">
                         <div class="card mb-4 shadow" style="height: 388px;">
                            <div class="card-header">🛑 Répartition par statut</div>
                            <div class="card-body">
                                 <canvas id="statutChart"></canvas>
                            </div>
                        </div>
                    </div>

                 </div>

            </div>
        </div>
    </div>
</x-app-layout>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const carsMois = @json($carsParMois);
    const carsParGamme = @json($carsParGamme);
    const carsParCarburant = @json($carsParCarburant);
    const carsParStatut = @json($carsParStatut);

    new Chart(document.getElementById('carsMois'), {
        type: 'line',
        data: {
            labels: carsMois.map(c => c.mois),
            datasets: [{
                label: 'Nombre de véhicules',
                data: carsMois.map(c => c.total),
                borderColor: 'blue',
                fill: false
            }]
        }
    });

    new Chart(document.getElementById('gammeChart'), {
        type: 'pie',
        data: {
            labels: carsParGamme.map(g => g.gamme),
            datasets: [{
                data: carsParGamme.map(g => g.total),
                backgroundColor: ['#3498db', '#e74c3c', '#2ecc71', '#9b59b6', '#f1c40f']
            }]
        }
    });

    new Chart(document.getElementById('carburantChart'), {
        type: 'bar',
        data: {
            labels: carsParCarburant.map(c => c.carburant),
            datasets: [{
                label: 'Véhicules',
                data: carsParCarburant.map(c => c.total),
                backgroundColor: '#2980b9'
            }]
        }
    });

    new Chart(document.getElementById('statutChart'), {
        type: 'doughnut',
        data: {
            labels: carsParStatut.map(s => s.statut),
            datasets: [{
                data: carsParStatut.map(s => s.total),
                backgroundColor: ['#2ecc71', '#e74c3c']
            }]
        }
    });
</script>