<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
             @include('cars.navigation')
        </x-slot>
        <a href="{{ route('cars.create') }}" class="btn btn-primary">+ Nouveau</a>
        <h4 style="float:right;width:fit-content;color:#333">Liste de véhicules</h4>
        <hr>

        @if (session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            <hr>
        @endif

        <div style="
            display: flex;
            justify-content: space-between;
            align-items: center;
            align-content: center;
            margin-bottom:15px !important

        ">
            <form method="GET" action="{{ route('cars.index') }}" class="mb-4" style="
                margin: 0px !important;
            ">
                @csrf
                <input type="text" name="search" placeholder="Rechercher..." class="border px-4 py-2 w-1/3" value="{{ request('search') }}" style="width:270px">
                <button type="submit" class="bg-blue-500 text-white px-4 py-2">Rechercher</button>
            </form>
            <div class="caption">
                 <a onclick="document.getElementById('bulk-delete-btn').click();" 
                    class="btn btn-default mt-2" 
                    style="background:transparent; border:1px solid #333; color:#333;">
                        <span class="fa fa-trash"></span> Supprimer
                </a>
            </div>
        </div>
        @foreach ($cars as $car)
            <form id="delete-form-{{ $car->id }}" action="{{ route('cars.destroy', $car->id) }}" method="POST" style="display: none;">
                @csrf
                @method('DELETE')
            </form>
        @endforeach

        <form id="bulk-delete-form" action="{{ route('cars.bulk-delete') }}" method="POST">
            @csrf
            @method('DELETE')
            <table class="table-auto w-full border-collapse border border-gray-300 shadow">
                <thead>
                <tr class="bg-gray-200">
                        <th class="border px-4 py-2">#</th>
                        <th class="border text-center" width="30">
                            <input type="checkbox" id="check-all">
                        </th>
                        <th class="border px-4 py-2">Marque</th>
                        <th class="border px-4 py-2">Modèle</th>
                        <th class="border px-4 py-2">Immatriculation</th>
                        <th class="border px-4 py-2">Carburant</th>
                        <th class="border px-4 py-2">Transmission</th>
                        <th class="border px-4 py-2">Proprietaire</th>
                        <th class="border px-4 py-2">Statut</th>
                        <th class="border px-4 py-2">Gamme</th>
                        <th class="border px-4 py-2">Action</th>
                    </tr>
                </thead>
                <tbody>
                @php $i = 1; @endphp
                    @foreach ($cars as $car)
                        <tr>
                            <td class="border px-4 py-2">{{ $i++ }}</td>
                            <td class="border text-center" width="30">
                                <input type="checkbox" name="ids[]" value="{{ $car->id }}" class="checkbox">
                            </td>
                            <td class="border px-4 py-2">{{ $car->marque }}</td>
                            <td class="border px-4 py-2">{{ $car->modele }}</td>
                            <td class="border px-4 py-2">{{ $car->immatriculation }}</td>
                            <td class="border px-4 py-2">{{ ucfirst($car->carburant) ?? 'Non défini' }}</td>
                            <td class="border px-4 py-2">{{ ucfirst($car->transmission) ?? 'Non défini' }}</td>
                            <td class="border px-4 py-2">
                                {{ $car->proprietaire->nom ?? 'Non attribué' }}
                            </td>
                            <td class="border px-4 py-2">
                                <span class="badge {{ $car->statut == 'disponible' ? 'bg-success' : 'bg-warning' }}">
                                    {{ ucfirst($car->statut) }}
                                </span>
                            </td>
                            <td class="border px-4 py-2">{{ $car->gamme->nom ?? 'Aucune' }}</td>
                            <td class="border px-4 py-2">
                                
                                <a href="{{ route('cars.edit', $car->id) }}" class="text text-info">
                                    <span class="fa fa-pencil-alt"></span>&nbsp;edit
                                </a> |
                                <a style="cursor:pointer" class="text text-danger delete-btn" data-id="{{ $car->id }}">
                                    <span class="fa fa-trash"></span>&nbsp;suppr.
                                </a>
                                
                            </td>
                        </tr>
                    @endforeach


                </tbody>
            </table>
            <button id="bulk-delete-btn" type="button"></button>
        </form>

        
        <!-- Pagination -->
        <div class="mt-4">
            {{ $cars->links() }} <!-- Cela génère les liens de pagination -->
        </div>

    </div>
</x-app-layout>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const deleteButtons = document.querySelectorAll('.delete-btn');

        deleteButtons.forEach(button => {
            button.addEventListener('click', function () {
                const userId = this.getAttribute('data-id');
               
                Swal.fire({
                    title: 'Êtes-vous sûr ?',
                    text: "Cette action est irréversible !",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Oui, supprimer',
                    cancelButtonText: 'Annuler'
                }).then((result) => {
                    if (result.isConfirmed) {
                        
                        document.getElementById('delete-form-' + userId).submit();
                    }
                });
            });
        });
    });
</script>

<script>
    document.getElementById('check-all').addEventListener('change', function () {
        const checkboxes = document.querySelectorAll('.checkbox');
        checkboxes.forEach(cb => cb.checked = this.checked);
    });

    document.getElementById('bulk-delete-btn').addEventListener('click', function () {
        const form = document.getElementById('bulk-delete-form');
        const selected = form.querySelectorAll('.checkbox:checked');

        if (selected.length === 0) {
            Swal.fire('Aucun élément sélectionné', 'Veuillez sélectionner au moins un utilisateur.', 'info');
            return;
        }

        Swal.fire({
            title: 'Confirmer la suppression ?',
            text: "Les vehicules sélectionnés seront supprimés.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Oui, supprimer',
            cancelButtonText: 'Annuler',
            confirmButtonColor: '#d33'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    });
</script>


