<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('cars.navigation')
        </x-slot>


        <a href="{{ route('gammes.create') }}" class="btn btn-primary mb-3">+ Nouvelle gamme</a>
        <h4 style="float:right;width:fit-content;color:#333">Liste des gammes de véhicules</h4>
        <hr>

        @if (session('success'))
            <div class="alert alert-success mt-3 mb-4">
                {{ session('success') }}
            </div>
        @endif

        <div class="flex justify-between items-center mb-4">
            <form method="GET" action="{{ route('gammes.index') }}">
                <input type="text" name="search" placeholder="Rechercher..." class="border px-4 py-2"
                       value="{{ request('search') }}">
                <button type="submit" class="bg-blue-500 text-white px-4 py-2">Rechercher</button>
            </form>

            <a onclick="document.getElementById('bulk-delete-btn').click();"
               class="btn btn-outline-secondary"
               style="background:transparent; border:1px solid #333; color:#333;">
                <span class="fa fa-trash"></span> Supprimer
            </a>
        </div>
        @foreach ($gammes as $gamme)
        <form id="delete-form-{{ $gamme->id }}" action="{{ route('gammes.destroy', $gamme->id) }}" method="POST" style="display: none;">
            @csrf
            @method('DELETE')
        </form>
        @endforeach
        <form id="bulk-delete-form" action="{{ route('gammes.bulk-delete') }}" method="POST">
            @csrf
            @method('DELETE')
            <table class="table-auto w-full border-collapse border border-gray-300 shadow">
                <thead>
                    <tr class="bg-gray-200">
                        <th class="border px-4 py-2">#</th>
                        <th class="border text-center" width="30"><input type="checkbox" id="check-all"></th>
                        <th class="border px-4 py-2">Nom</th>
                        <th class="border px-4 py-2">Tarif (xaf)</th>
                        <th class="border px-4 py-2">Description</th>
                        <th class="border px-4 py-2">Créé le</th>
                        <th class="border px-4 py-2">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @php $i = 1; @endphp
                    @foreach ($gammes as $gamme)
                        <tr>
                            <td class="border px-4 py-2">{{ $i++ }}</td>
                            <td class="border text-center">
                                <input type="checkbox" name="ids[]" value="{{ $gamme->id }}" class="checkbox">
                            </td>
                            <td class="border px-4 py-2">{{ $gamme->libelle }}</td>
                            <td class="border px-4 py-2">{{ number_format($gamme->tarif, 0, ',', ' ') }}</td>
                            <td class="border px-4 py-2">{{ Str::limit($gamme->description, 60) }}</td>
                            <td class="border px-4 py-2">{{ $gamme->created_at}}</td>
                            <td class="border px-4 py-2">
                                <a href="{{ route('gammes.edit', $gamme->id) }}" class="text-blue-600"><span class="fa fa-pencil-alt"></span> Modifier</a> |
                                <a href="#" class="text-red-600 delete-btn" data-id="{{ $gamme->id }}"><span class="fa fa-trash"></span> Supprimer</a>
                                
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <button id="bulk-delete-btn" type="button" style="display:none;"></button>
        </form>

        <div class="mt-4">
            {{ $gammes->links() }}
        </div>
    </div>
</x-app-layout>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Suppression individuelle
        document.querySelectorAll('.delete-btn').forEach(button => {
            button.addEventListener('click', function () {
                const id = this.dataset.id;
                Swal.fire({
                    title: 'Supprimer cette gamme ?',
                    text: "Cette action est irréversible.",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Oui, supprimer',
                    cancelButtonText: 'Annuler'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById('delete-form-' + id).submit();
                    }
                });
            });
        });

        // Sélection tous les checkboxes
        document.getElementById('check-all').addEventListener('change', function () {
            document.querySelectorAll('.checkbox').forEach(cb => cb.checked = this.checked);
        });

        // Suppression en groupe
        document.getElementById('bulk-delete-btn').addEventListener('click', function () {
            const form = document.getElementById('bulk-delete-form');
            const selected = form.querySelectorAll('.checkbox:checked');

            if (selected.length === 0) {
                Swal.fire('Aucun élément sélectionné', 'Veuillez sélectionner au moins une gamme.', 'info');
                return;
            }

            Swal.fire({
                title: 'Confirmer la suppression ?',
                text: "Les gammes sélectionnées seront supprimées.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Oui, supprimer',
                cancelButtonText: 'Annuler',
                confirmButtonColor: '#d33'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });
</script>
