<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('cars.navigation')
        </x-slot>

        <a href="{{ route('gammes.index') }}" class="btn btn-primary mb-3">+ Gamme de vehicules</a>
        <h4 style="float:right;width:fit-content;color:#333">Modication gamme de véhicule</h4>
        <hr>

        <div class="container">
            @if ($errors->any())
                <div class="alert alert-danger my-3">
                    <ul class="list-disc list-inside text-red-600">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-4 shadow bg-white rounded">
                <form method="POST" action="{{ route('gammes.update', $gamme->id) }}" class="space-y-4">
                    @csrf
                    @method('PUT')

                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="libelle">Nom de la gamme :</label>
                                <input type="text" name="libelle" id="libelle" value="{{ old('libelle', $gamme->libelle) }}"
                                    class="form-control w-full border px-3 py-2" required>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="tarif">Tarif (xaf) :</label>
                                <input type="number" name="tarif" id="tarif" value="{{ old('tarif', $gamme->tarif) }}"
                                    class="form-control w-full border px-3 py-2" step="0.01" required>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label for="description">Description :</label>
                                <textarea name="description" id="description"
                                    class="form-control w-full border px-3 py-2"
                                    rows="4">{{ old('description', $gamme->description) }}</textarea>
                            </div>
                        </div>
                    </div>

                    <button type="submit"
                        class="btn btn-primary">
                        Mettre à jour
                    </button>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
