<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('cars.navigation')
        </x-slot>

        <a href="{{ route('cars.index') }}" class="btn btn-primary mb-3">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">Nouveau vehicule</h4>
        <hr>

        <div class="container">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3 shadow">
                <form method="POST" action="{{ route('cars.store') }}" enctype="multipart/form-data" class="space-y-4">
                    @csrf

                    <div class="row">
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label>Marque :</label>
                                <input type="text" name="marque" value="{{ old('marque') }}" class="form-control w-full border px-3 py-2" required>
                            </div>
                            <div class="form-group">
                                <label>Modèle :</label>
                                <input type="text" name="modele" value="{{ old('modele') }}" class="form-control w-full border px-3 py-2" required>
                            </div>
                            <div class="form-group">
                                <label>Année :</label>
                                <input type="number" name="annee" value="{{ old('annee') }}" class="form-control w-full border px-3 py-2" required>
                            </div>
                            <div class="form-group">
                                <label>Immatriculation :</label>
                                <input type="text" name="immatriculation" value="{{ old('immatriculation') }}" class="form-control w-full border px-3 py-2" required>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label>Carburant :</label>
                                <select name="carburant" class="form-control w-full border px-3 py-2">
                                    <option value="essence">Essence</option>
                                    <option value="diesel">Diesel</option>
                                    <option value="électrique">Électrique</option>
                                    <option value="hybride">Hybride</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Transmission :</label>
                                <select name="transmission" class="form-control w-full border px-3 py-2">
                                    <option value="manuelle">Manuelle</option>
                                    <option value="automatique">Automatique</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Kilométrage :</label>
                                <input type="number" name="kilometrage" value="{{ old('kilometrage') }}" class="form-control w-full border px-3 py-2">
                            </div>
                            <div class="form-group">
                                <label>Nombre de places :</label>
                                <input type="number" name="nombre_places" value="{{ old('nombre_places') }}" class="form-control w-full border px-3 py-2">
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label>Propriétaire :</label>
                                <select name="id_proprietaire" class="form-control w-full border px-3 py-2">
                                    @foreach ($users as $user)
                                        <option value="{{ $user->id }}" {{ old('id_proprietaire') == $user->id ? 'selected' : '' }}>
                                            {{ $user->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Statut :</label>
                                <select name="statut" class="form-control w-full border px-3 py-2">
                                    <option value="disponible">Disponible</option>
                                    <option value="occupé">Occupé</option>
                                    <option value="maintenance">Maintenance</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Image :</label>
                                <input type="file" name="image" class="form-control w-full border px-3 py-2">
                            </div>
                            <div class="form-group">
                                <label>Description :</label>
                                <textarea name="description" class="form-control w-full border px-3 py-2">{{ old('description') }}</textarea>
                            </div>
                        </div>
                    </div>

                    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded">Enregistrer</button>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
