<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2.5rem !important;
    }
</style>
<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
           @include('parametres.navigation')
        </x-slot>


        <a href="{{ route('arrondissement.index') }}" class="btn btn-danger mb-1">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">Nouvel arrondissement</h4>
        <hr>


        <div class="content">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3">
                <div class="row">
                    <div class="col-md-3">
                        <div class="card p-4">
                            <form action="{{ route('arrondissement.update',$arrondissement->id) }}" method="POST">
                                @csrf
                                @method('PUT')

                                <div class="mb-1">
                                    <label for="name" class="form-label">Nom de l'arrondissement</label>
                                    <input type="text" name="name" class="form-control" id="name" value="{{ old('name', $arrondissement->name ?? '') }}" required>
                                </div>

                                <div class="mb-1">
                                    <label for="code" class="form-label">Code</label>
                                    <input type="text" name="code" class="form-control" id="code" value="{{ old('code', $arrondissement->code ?? '') }}" required>
                                </div>

                                <div class="mb-1">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea name="description" class="form-control" id="description" rows="3">{{ old('description', $arrondissement->description ?? '') }}</textarea>
                                </div>

                                <div class="mb-1">
                                    <label for="description" class="form-label">zone</label>
                                    <select name="zone_id" class="form-control" required>
                                        <option value="">-- Sélectionner --</option>
                                        @foreach($zones as $zone)
                                            <option value="{{ $zone->id }}" @if ($zone->id == $arrondissement->zone->id)
                                                selected
                                            @endif>{{ $zone->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <button type="submit" class="btn btn-primary">
                                    {{ isset($arrondissement) ? 'Mettre à jour' : 'Créer' }}
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
                
            </div>
                
        </div>
    </div>
</x-app-layout>

