<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Prison;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        // Crée une prison fictive si aucune n'existe
        // $prison = Prison::firstOrCreate([
        //     'name' => 'Prison Centrale de Brazzaville',
        // ]);

        // Admin principal
        $admin = User::create([
            'name' => 'Admin Général',
            'email' => 'admin@prison.cg',
            'password' => 'admin123',
            'phone_number' => '066000001',
            'role' => 'admin',
            'is_active' => true,
            'assigned_prison_id' => 1,
        ]);

        // Autres utilisateurs
        $users = [
            ['Chef Prison Admin', 'cpa@prison.cg', 'cpa123', 'cpa'],
            ['Chef Quartier', 'cpq@prison.cg', 'cpq123', 'cpq'],
            ['Chef Poste', 'cp@prison.cg', 'cp123', 'cp'],
            ['Chef Transit', 'ct@prison.cg', 'ct123', 'ct'],
            ['Chef Cellule', 'cc@prison.cg', 'cc123', 'cc'],
            ['Geolier Responsable', 'geolier@prison.cg', 'geolier123', 'geolier'],
        ];

        foreach ($users as [$name, $email, $password, $role]) {
            User::create([
                'name' => $name,
                'email' => $email,
                'password' => $password,
                'phone_number' => fake()->phoneNumber(),
                'role' => $role,
                'is_active' => true,
                'assigned_prison_id' => 1,
                'created_by' => $admin->id,
            ]);
        }
    }
}
