<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Zone;
use App\Models\Arrondissement;
use App\Models\Quartier;
use App\Models\Prison;
use App\Models\Ville;

// php artisan make:seeder PrisonSeeder
class PrisonSeeder extends Seeder {
    public function run(): void {
        $bacongo = Quartier::where('code', 'BCG')->first();
        $loandjili = Quartier::where('code', 'LDJ')->first();

        Prison::create([
            'name' => 'Maison d\'arrêt de Brazzaville',
            'code' => 'PRSN-BZV-001',
            'description' => 'Prison principale de Brazzaville',
            'type' => 'CC',
            'location' => 'Avenue de la Maison d\'Arrêt',
            'capacity' => 1500,
            'phone' => '06 000 0001',
            'email' => 'prison.brazzaville@gouv.cg',
            'latitude' => -4.2634,
            'longitude' => 15.2429,
            'is_active' => true,
            'quartier_id' => $bacongo->id
        ]);

        Prison::create([
            'name' => 'Maison d\'arrêt de Pointe-Noire',
            'code' => 'PRSN-PNR-001',
            'description' => 'Prison principale de Pointe-Noire',
            'type' => 'CPA',
            'location' => 'Route de l\'aéroport',
            'capacity' => 1200,
            'phone' => '06 000 0002',
            'email' => 'prison.pointe-noire@gouv.cg',
            'latitude' => -4.7882,
            'longitude' => 11.8651,
            'is_active' => true,
            'quartier_id' => $loandjili->id
        ]);
    }
}
