<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Zone;
use App\Models\Arrondissement;
use App\Models\Quartier;
use App\Models\Prison;
use App\Models\Ville;

class ArrondissementSeeder extends Seeder {
    public function run(): void {
        $cv = Zone::where('code', 'CV-BZV')->first();
        $tt = Zone::where('code', 'TT-PNR')->first();

        Arrondissement::create(['name' => 'Makélékélé', 'code' => 'MKL', 'description' => 'Sud Brazzaville', 'zone_id' => $cv->id]);
        Arrondissement::create(['name' => 'Mvoumvou', 'code' => 'MVV', 'description' => 'Centre Pointe-Noire', 'zone_id' => $tt->id]);
    }
}
