<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePrisonniersTable extends Migration
{
    public function up()
    {
        Schema::create('prisonniers', function (Blueprint $table) {
            $table->id();
            $table->string('nom');
            $table->string('prenom');
            $table->string('matricule')->unique();
            $table->enum('sexe', ['Homme', 'Femme']);
            $table->date('date_naissance')->nullable();
            $table->string('lieu_naissance')->nullable();
            $table->string('nationalite')->nullable();
            $table->enum('statut_matrimonial', ['Célibataire', 'Marié(e)', 'Divorcé(e)', 'Veuf(ve)'])->nullable();
            $table->string('photo')->nullable(); // <-- Photo
            $table->foreignId('prison_id')->constrained()->onDelete('cascade');
            $table->date('date_incarceration');
            $table->date('date_liberation_prevue')->nullable();
            $table->string('motif')->nullable();
            $table->enum('statut', ['Actif', 'Libéré', 'Transféré'])->default('Actif');
            $table->timestamps();
        });


    }

    public function down()
    {
        Schema::dropIfExists('prisonniers');
    }
}
