<?php

// app/Models/User.php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Hash;

class User extends Authenticatable
{
    use Notifiable;

    protected $fillable = [
        'name',
        'email',
        'password',
        'phone_number',
        'role',
        'assigned_prison_id',
        'photo',
        'is_active',
        'last_login_at',
        'created_by',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'last_login_at' => 'datetime',
    ];

    // 🔗 Relations
    public function prison()
    {
        return $this->belongsTo(Prison::class, 'assigned_prison_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function createdUsers()
    {
        return $this->hasMany(User::class, 'created_by');
    }

    // 🔐 Helpers
    public function isAdmin()
    {
        return $this->role === 'admin';
    }

    public function isCpa()
    {
        return $this->role === 'cpa';
    }

    public function isCpq()
    {
        return $this->role === 'cpq';
    }

    public function isCp()
    {
        return $this->role === 'cp';
    }
    public function isGeo()
    {
        return $this->role === 'cp';
    }

    // 🔐 Mutateur automatique du mot de passe
    public function setPasswordAttribute($value)
    {
        $this->attributes['password'] = Hash::make($value);
    }
}

