<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Prisonier extends Model
{
    use HasFactory;

    protected $fillable = [
        'nom',
        'prenom',
        'matricule',
        'sexe',
        'date_naissance',
        'lieu_naissance',
        'nationalite',
        'statut_matrimonial',
        'photo', // <- ajouté
        'prison_id',
        'date_incarceration',
        'date_liberation_prevue',
        'motif',
        'statut',
    ];


    public function prison()
    {
        return $this->belongsTo(Prison::class);
    }

    public function crimes()
    {
        return $this->belongsToMany(Crime::class, 'crime_prisonnier', 'prisonnier_id', 'crime_id')
                    ->withPivot('rôle', 'date_implication', 'condamnation');
    }

    public function arrestations()
    {
        return $this->hasMany(Arrestation::class);
    }

}
