<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Operation extends Model
{
    use HasFactory;

    protected $fillable = [
        'type',        // Type de matériel (arme, véhicule, matraque, etc.)
        'description', // Description détaillée du matériel
        'responsable',    // Quantité de ce type de matériel
        'date_operation',  // Date d'attribution du matériel
        'prison_id',    // La prison à laquelle le matériel est attribué
        'rapport'    // La prison à laquelle le matériel est attribué
    ];

    /**
     * Relation avec la prison.
     */
    public function prison()
    {
        return $this->belongsTo(Prison::class);
    }
}
