<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MaterielPrison extends Model
{
    use HasFactory;

    protected $fillable = [
        'type',        // Type de matériel (arme, véhicule, matraque, etc.)
        'description', // Description détaillée du matériel
        'quantite',    // Quantité de ce type de matériel
        'date_attribution',  // Date d'attribution du matériel
        'prison_id',    // La prison à laquelle le matériel est attribué
    ];

    /**
     * Relation avec la prison.
     */
    public function prison()
    {
        return $this->belongsTo(Prison::class);
    }
}
