<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DeferrePrisonier extends Model
{
    use HasFactory;

    protected $fillable = [
        'prison_id',       // Identifiant de la prison
        'crime_id',        // Identifiant du crime associé
        'prisonnier_id',   // Identifiant du prisonnier
        'date_defere',     // Date du déferrement
        'autorite_id',     // Autorité responsable du déferrement
        'status',          // Statut du déféré (par exemple, "En cours", "Terminé")
    ];

    /**
     * Relation avec la table Prison
     */
    public function prison()
    {
        return $this->belongsTo(Prison::class);
    }

    /**
     * Relation avec la table Crime
     */

    /**
     * Relation avec la table Prisonnier
     */
    public function prisonnier()
    {
        return $this->belongsTo(Prisonnier::class);
    }

    /**
     * Relation avec l'Autorité responsable
     */
    public function autorite()
    {
        return $this->belongsTo(User::class, 'autorite_id');
    }
}
