<?php
// app/Models/CrimePrisonnier.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CrimePrisonier extends Model
{
    use HasFactory;

    // Spécifier la table si nécessaire (par défaut, Laravel suppose le nom de la table au pluriel)
    protected $table = 'crime_prisonnier';

    // Les attributs qui peuvent être assignés en masse
    protected $fillable = [
        'crime_id',
        'prisonnier_id',
        'rôle',
        'date_implication',
        'condamnation',
    ];

    // Définir les relations

    // Relation avec le modèle Crime
    public function crime()
    {
        return $this->belongsTo(Crime::class);
    }

    // Relation avec le modèle Prisonnier
    public function prisonnier()
    {
        return $this->belongsTo(Prisonier::class);
    }
}
