<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Arrestation extends Model
{
    use HasFactory;

    protected $fillable = [
        'prisonier_id',
        'responsable_id',
        'prison_id',
        'date_arrestation',
        'statut',
        'date_relachement',
    ];

    // Relation avec l'utilisateur (autorité responsable)
    public function user()
    {
        return $this->belongsTo(User::class, 'responsable_id');
    }

    // Relation avec la prison
    public function prison()
    {
        return $this->belongsTo(Prison::class, 'prison_id');
    }
    public function prisonier()
    {
        return $this->belongsTo(Prisonier::class, 'prisonier_id');
    }

    // Relation avec les crimes (modèle pivot)
    public function crimes()
    {
        return $this->belongsToMany(Crime::class, 'arrestation_crime');
    }
}
