<?php

namespace App\Http\Controllers;

use App\Models\Zone;
use App\Models\Ville;
use Illuminate\Http\Request;

class ZoneController extends Controller
{
    public function index() {
       $zones = Zone::all();
        return view('zones.index', compact('zones'));
    }

    public function create() {
         $villes = Ville::all();

        return view('zones.create', compact('villes'));
    }

    public function store(Request $request) {
        Zone::create($request->all());
        return redirect()->route('zone.index');
    }

    public function edit($id) {
       $zone=Zone::findOrFail($id);
       $villes = Ville::all();

        return view('zones.edit', compact('zone', 'villes'));
    }


    public function update(Request $request,$id) {
        $zone = Zone::findOrFail($id);

        // Validation des données reçues depuis le formulaire
       $validated= $request->validate([
            'code' => 'required|string|max:255',
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'ville_id' => 'required|numeric|exists:villes,id',
             // Vérifie que la prison existe
        ]);

       $zone->update($validated);
        return redirect()->route('zone.index');
    }

    public function destroy(Zone$zone) {
       $zone->delete();
        return redirect()->route('zones.index');
    }
}
