<?php

namespace App\Http\Controllers;

use App\Models\Ville;
use Illuminate\Http\Request;

class VilleController extends Controller
{
    public function index() {
        $villes = Ville::all();
        return view('villes.index', compact('villes'));
    }

    public function create() {
        return view('villes.create');
    }

    public function store(Request $request) {
        Ville::create($request->all());
        return redirect()->route('ville.index');
    }

    public function edit($id) {
        $ville=Ville::findOrFail($id);
        return view('villes.edit', compact('ville'));
    }


    public function update(Request $request,$id) {
         $ville = Ville::findOrFail($id);

        // Validation des données reçues depuis le formulaire
       $validated= $request->validate([
            'code' => 'required|string|max:255',
            'name' => 'required|string|max:255',
            'description' => 'nullable|string'
             // Vérifie que la prison existe
        ]);

       

        $ville->update($validated);
        return redirect()->route('ville.index');
    }

    public function destroy(Ville $ville) {
        $ville->delete();
        return redirect()->route('villes.index');
    }
}
