<?php

namespace App\Http\Controllers;

use App\Models\Voiture;
use App\Models\MaterielPrison;
use App\Models\Prison;
use App\Models\Operation ;
use Illuminate\Http\Request;

class OperationController extends Controller
{

    public function index(Request $request)
    {
       
        $operations = Operation::with('prison')->get();
        $title="Liste des operations";
        return view('operations.index', compact('operations','title'));
    }


    // Affiche le formulaire de création
    public function create()
    {
        $prisons=Prison::all();
        return view('operations.create',compact('prisons'));
    }

    // Enregistre une nouvelle gamme
   public function store(Request $request)
    {
        // Validation des données reçues depuis le formulaire
        $request->validate([
            'type' => 'required|string|max:255',
            'description' => 'required|string|max:255',
            'responsable' => 'required|string|max:255',
            'date_operation' => 'required|date',
            'prison_id' => 'required|exists:prisons,id', // Vérifie que la prison existe
            'rapport' => 'nullable|string' // Vérifie que la prison existe
        ]);

        // Création du matériel en utilisant les données validées
        Operation::create([
            'type' => $request->input('type'),
            'description' => $request->input('description'),
            'responsable' => $request->input('responsable'),
            'date_operation' => $request->input('date_operation'),
            'prison_id' => $request->input('prison_id'),
            'rapport' => $request->input('rapport')
        ]);

        // Rediriger vers une autre page ou afficher un message de succès
        return redirect()->route('operations.index')->with('success', 'Operation ajoutée avec succès!');
    }

    // Affiche le formulaire d'édition
    public function edit($id)
    {
        $operation = Operation::findOrFail($id);
        $prisons=Prison::all();
        return view('operations.edit', compact('operation','prisons'));
    }

    // Met à jour une gamme existante
    public function update(Request $request, $id)
    {
        $operation = Operation::findOrFail($id);

        // Validation des données reçues depuis le formulaire
         $validated=$request->validate([
            'type' => 'required|string|max:255',
            'description' => 'required|string|max:255',
            'responsable' => 'required|string|max:255',
            'date_operation' => 'required|date',
            'prison_id' => 'required|exists:prisons,id', // Vérifie que la prison existe
            'rapport' => 'nullable|string' // Vérifie que la prison existe
        ]);

    
        $operation->update($validated);

        return redirect()->route('operations.index')->with('success', 'Operation mise à jours avec succès');
    }

    // Supprime une gamme
}
