<?php

namespace App\Http\Controllers;

use App\Models\Voiture;
use App\Models\MaterielPrison;
use App\Models\Prison;
use Illuminate\Http\Request;

class MaterielPrisonController extends Controller
{

    public function index(Request $request)
    {
       
        $materiels = MaterielPrison::with('prison')->get();
        $title="Liste des materiels";
        return view('materiel_prison.index', compact('materiels','title'));
    }


    // Affiche le formulaire de création
    public function create()
    {
        $prisons=Prison::all();
        return view('materiel_prison.create',compact('prisons'));
    }

    // Enregistre une nouvelle gamme
   public function store(Request $request)
    {
        // Validation des données reçues depuis le formulaire
        $request->validate([
            'type' => 'required|string|max:255',
            'description' => 'required|string|max:255',
            'quantite' => 'required|integer|min:1',
            'date_attribution' => 'required|date',
            'prison_id' => 'required|exists:prisons,id', // Vérifie que la prison existe
        ]);

        // Création du matériel en utilisant les données validées
        MaterielPrison::create([
            'type' => $request->input('type'),
            'description' => $request->input('description'),
            'quantite' => $request->input('quantite'),
            'date_attribution' => $request->input('date_attribution'),
            'prison_id' => $request->input('prison_id'),
        ]);

        // Rediriger vers une autre page ou afficher un message de succès
        return redirect()->route('materiels.index')->with('success', 'Matériel ajouté avec succès!');
    }

    // Affiche le formulaire d'édition
    public function edit($id)
    {
        $materiel = MaterielPrison::findOrFail($id);
        $prisons=Prison::all();
        return view('materiel_prison.edit', compact('materiel','prisons'));
    }

    // Met à jour une gamme existante
    public function update(Request $request, $id)
    {
        $materiels = MaterielPrison::findOrFail($id);

        // Validation des données reçues depuis le formulaire
       $validated= $request->validate([
            'type' => 'required|string|max:255',
            'description' => 'required|string|max:255',
            'quantite' => 'required|integer|min:1',
            'date_attribution' => 'required|date',
            'prison_id' => 'required|exists:prisons,id', // Vérifie que la prison existe
        ]);

       

        $materiels->update($validated);

        return redirect()->route('materiels.index')->with('success', 'Materiel mis à jours avec succès');
    }

    // Supprime une gamme
}
