<?php

namespace App\Http\Controllers;

use App\Models\Voiture;
use App\Models\GammesVehicules;
use Illuminate\Http\Request;

class GammeController extends Controller
{

    public function index(Request $request)
    {
        $search = $request->input('search');
 
        $gammes = GammesVehicules::when($search, function ($query, $search) {
                return $query->where('nom', 'like', '%' . $search . '%')
                            ->orWhere('description', 'like', '%' . $search . '%');
            })
            ->orderBy('created_at', 'desc')
            ->paginate(10);

        return view('cars.gammes.index', compact('gammes'));
    }

    public function affectergamme(Request $request){
        $request->validate([
            'car_ids' => 'required|array',
            'gamme_id' => 'required|exists:gammes_vehicules,id',
        ]);

       // dd($request);
    
        // Mise à jour de toutes les voitures sélectionnées
        Voiture::whereIn('id', $request->car_ids)->update([
            'gamme_id' => $request->gamme_id,
        ]);
    
        return redirect()->back()->with('success', 'Gamme affectée avec succès aux véhicules sélectionnés.');
    
    }

    // Affiche le formulaire de création
    public function create()
    {
        return view('cars.gammes.create');
    }
    public function affectation(Request $request)
    {
        $gammes = GammesVehicules::all(); // Toutes les gammes
        $cars = Voiture::with(['gamme'])->get();
        return view('cars.gammes.affectation', compact('gammes', 'cars'));
    }

    // Enregistre une nouvelle gamme
    public function store(Request $request)
    {
        $request->validate([
            'libelle' => 'required|string|max:255|unique:gammes_vehicules,libelle',
            'tarif' => 'required|numeric|min:0',
            'description' => 'nullable|string',
        ]);

        GammesVehicules::create($request->only('libelle', 'tarif', 'description'));

        return redirect()->route('gammes.index')->with('success', 'Gamme ajoutée avec succès.');
    }

    // Affiche le formulaire d'édition
    public function edit($id)
    {
        $gamme = GammesVehicules::findOrFail($id);
        return view('cars.gammes.edit', compact('gamme'));
    }

    // Met à jour une gamme existante
    public function update(Request $request, $id)
    {
        $gamme = GammesVehicules::findOrFail($id);

        $request->validate([
            'libelle' => 'required|string|max:255|unique:gammes_vehicules,libelle,' . $gamme->id,
            'tarif' => 'required|numeric|min:0',
            'description' => 'nullable|string',
        ]);

        $gamme->update($request->only('libelle', 'tarif', 'description'));

        return redirect()->route('gammes.index')->with('success', 'Gamme mise à jour avec succès.');
    }

    // Supprime une gamme
    public function destroy($id)
    {
      
        $gamme = GammesVehicules::findOrFail($id);
        $gamme->delete();

        return redirect()->route('gammes.index')->with('success', 'Gamme supprimée avec succès.');
    }

    // Suppression en masse
    public function bulkDelete(Request $request)
    {
        $ids = $request->input('ids');

        if ($ids && is_array($ids)) {
            GammesVehicules::whereIn('id', $ids)->delete();
            return redirect()->route('gammes.index')->with('success', 'Gammes supprimées avec succès.');
        }

        return redirect()->route('gammes.index')->with('error', 'Aucune gamme sélectionnée.');
    }
}
