<?php

namespace App\Http\Controllers;

use App\Models\Arrondissement;
use App\Models\Zone;
use Illuminate\Http\Request;

class ArrondissementController extends Controller
{
    public function index() {
       $arrondissements = Arrondissement::all();
        return view('arrondissements.index', compact('arrondissements'));
    }

    public function create() {
         $zones = Zone::all();

        return view('arrondissements.create', compact('zones'));
    }

    public function store(Request $request) {
        arrondissement::create($request->all());
        return redirect()->route('arrondissement.index');
    }

    public function edit($id) {
       $arrondissement=arrondissement::findOrFail($id);
       $zones = Zone::all();

        return view('arrondissements.edit', compact('arrondissement', 'zones'));
    }


    public function update(Request $request,$id) {
        $arrondissement = arrondissement::findOrFail($id);

        // Validation des données reçues depuis le formulaire
       $validated= $request->validate([
            'code' => 'required|string|max:255',
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'zone_id' => 'required|numeric|exists:zones,id',
             // Vérifie que la prison existe
        ]);

       $arrondissement->update($validated);
        return redirect()->route('arrondissement.index');
    }

    public function destroy(arrondissement$arrondissement) {
       $arrondissement->delete();
        return redirect()->route('arrondissements.index');
    }
}
